package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ModifyVolumeStatus represents the status object of ControllerModifyVolume operation */
final case class ModifyVolumeStatus(
  status : String,
  targetVolumeAttributesClassName : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : ModifyVolumeStatus = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : ModifyVolumeStatus = copy(status = f(status))

  /** Returns a new data with targetVolumeAttributesClassName set to new value */
  def withTargetVolumeAttributesClassName(value: String) : ModifyVolumeStatus = copy(targetVolumeAttributesClassName = Some(value))
  /** if targetVolumeAttributesClassName has a value, transforms to the result of function*/
  def mapTargetVolumeAttributesClassName(f: String => String) : ModifyVolumeStatus = copy(targetVolumeAttributesClassName = targetVolumeAttributesClassName.map(f))
}

object ModifyVolumeStatus {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ModifyVolumeStatus] = new Encoder[io.k8s.api.core.v1.ModifyVolumeStatus] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ModifyVolumeStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("targetVolumeAttributesClassName", o.targetVolumeAttributesClassName)
            .build
        }
    }

    implicit val decoder: Decoder[ModifyVolumeStatus] = new Decoder[ModifyVolumeStatus] {
      def apply[T : Reader](t: T): Either[String, ModifyVolumeStatus] = for {
          obj <- ObjectReader(t)
          status <- obj.read[String]("status")
          targetVolumeAttributesClassName <- obj.readOpt[String]("targetVolumeAttributesClassName")
      } yield ModifyVolumeStatus (
          status = status,
          targetVolumeAttributesClassName = targetVolumeAttributesClassName
        )
    }
}

