package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NamespaceStatus is information about the current status of a Namespace. */
final case class NamespaceStatus(
  conditions : Option[Seq[io.k8s.api.core.v1.NamespaceCondition]] = None,
  phase : Option[String] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.core.v1.NamespaceCondition]) : NamespaceStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.core.v1.NamespaceCondition*) : NamespaceStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.core.v1.NamespaceCondition] => Seq[io.k8s.api.core.v1.NamespaceCondition]) : NamespaceStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with phase set to new value */
  def withPhase(value: String) : NamespaceStatus = copy(phase = Some(value))
  /** if phase has a value, transforms to the result of function*/
  def mapPhase(f: String => String) : NamespaceStatus = copy(phase = phase.map(f))
}

object NamespaceStatus {

    implicit val encoder : Encoder[io.k8s.api.core.v1.NamespaceStatus] = new Encoder[io.k8s.api.core.v1.NamespaceStatus] {
        def apply[T : Builder](o: io.k8s.api.core.v1.NamespaceStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .write("phase", o.phase)
            .build
        }
    }

    implicit val decoder: Decoder[NamespaceStatus] = new Decoder[NamespaceStatus] {
      def apply[T : Reader](t: T): Either[String, NamespaceStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.api.core.v1.NamespaceCondition]]("conditions")
          phase <- obj.readOpt[String]("phase")
      } yield NamespaceStatus (
          conditions = conditions,
          phase = phase
        )
    }
}

