package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodDNSConfigOption defines DNS resolver options of a pod. */
final case class PodDNSConfigOption(
  name : Option[String] = None,
  value : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : PodDNSConfigOption = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : PodDNSConfigOption = copy(name = name.map(f))

  /** Returns a new data with value set to new value */
  def withValue(value: String) : PodDNSConfigOption = copy(value = Some(value))
  /** if value has a value, transforms to the result of function*/
  def mapValue(f: String => String) : PodDNSConfigOption = copy(value = value.map(f))
}

object PodDNSConfigOption {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodDNSConfigOption] = new Encoder[io.k8s.api.core.v1.PodDNSConfigOption] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodDNSConfigOption) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("value", o.value)
            .build
        }
    }

    implicit val decoder: Decoder[PodDNSConfigOption] = new Decoder[PodDNSConfigOption] {
      def apply[T : Reader](t: T): Either[String, PodDNSConfigOption] = for {
          obj <- ObjectReader(t)
          name <- obj.readOpt[String]("name")
          value <- obj.readOpt[String]("value")
      } yield PodDNSConfigOption (
          name = name,
          value = value
        )
    }
}

