package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodResourceClaimStatus is stored in the PodStatus for each PodResourceClaim which references a ResourceClaimTemplate. It stores the generated name for the corresponding ResourceClaim. */
final case class PodResourceClaimStatus(
  name : String,
  resourceClaimName : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : PodResourceClaimStatus = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : PodResourceClaimStatus = copy(name = f(name))

  /** Returns a new data with resourceClaimName set to new value */
  def withResourceClaimName(value: String) : PodResourceClaimStatus = copy(resourceClaimName = Some(value))
  /** if resourceClaimName has a value, transforms to the result of function*/
  def mapResourceClaimName(f: String => String) : PodResourceClaimStatus = copy(resourceClaimName = resourceClaimName.map(f))
}

object PodResourceClaimStatus {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodResourceClaimStatus] = new Encoder[io.k8s.api.core.v1.PodResourceClaimStatus] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodResourceClaimStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("resourceClaimName", o.resourceClaimName)
            .build
        }
    }

    implicit val decoder: Decoder[PodResourceClaimStatus] = new Decoder[PodResourceClaimStatus] {
      def apply[T : Reader](t: T): Either[String, PodResourceClaimStatus] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          resourceClaimName <- obj.readOpt[String]("resourceClaimName")
      } yield PodResourceClaimStatus (
          name = name,
          resourceClaimName = resourceClaimName
        )
    }
}

