package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PodTemplate describes a template for creating copies of a predefined pod. */
final case class PodTemplate(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  template : Option[io.k8s.api.core.v1.PodTemplateSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PodTemplate", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodTemplate = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodTemplate = copy(metadata = metadata.map(f))

  /** Returns a new data with template set to new value */
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : PodTemplate = copy(template = Some(value))
  /** if template has a value, transforms to the result of function*/
  def mapTemplate(f: io.k8s.api.core.v1.PodTemplateSpec => io.k8s.api.core.v1.PodTemplateSpec) : PodTemplate = copy(template = template.map(f))

  override def foldTo[T : Builder] : T = PodTemplate.encoder.apply(this)
}

object PodTemplate {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodTemplate] = new Encoder[io.k8s.api.core.v1.PodTemplate] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodTemplate) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("template", o.template)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PodTemplate] = new Decoder[PodTemplate] {
      def apply[T : Reader](t: T): Either[String, PodTemplate] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          template <- obj.readOpt[io.k8s.api.core.v1.PodTemplateSpec]("template")
      } yield PodTemplate (
          metadata = metadata,
          template = template
        )
    }
}

