package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ResourceClaim references one entry in PodSpec.ResourceClaims. */
final case class ResourceClaim(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourceClaim = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ResourceClaim = copy(name = f(name))
}

object ResourceClaim {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ResourceClaim] = new Encoder[io.k8s.api.core.v1.ResourceClaim] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ResourceClaim) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaim] = new Decoder[ResourceClaim] {
      def apply[T : Reader](t: T): Either[String, ResourceClaim] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield ResourceClaim (
          name = name
        )
    }
}

