package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from. */
final case class VolumeNodeAffinity(
  required : Option[io.k8s.api.core.v1.NodeSelector] = None
) {

  /** Returns a new data with required set to new value */
  def withRequired(value: io.k8s.api.core.v1.NodeSelector) : VolumeNodeAffinity = copy(required = Some(value))
  /** if required has a value, transforms to the result of function*/
  def mapRequired(f: io.k8s.api.core.v1.NodeSelector => io.k8s.api.core.v1.NodeSelector) : VolumeNodeAffinity = copy(required = required.map(f))
}

object VolumeNodeAffinity {

    implicit val encoder : Encoder[io.k8s.api.core.v1.VolumeNodeAffinity] = new Encoder[io.k8s.api.core.v1.VolumeNodeAffinity] {
        def apply[T : Builder](o: io.k8s.api.core.v1.VolumeNodeAffinity) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("required", o.required)
            .build
        }
    }

    implicit val decoder: Decoder[VolumeNodeAffinity] = new Decoder[VolumeNodeAffinity] {
      def apply[T : Reader](t: T): Either[String, VolumeNodeAffinity] = for {
          obj <- ObjectReader(t)
          required <- obj.readOpt[io.k8s.api.core.v1.NodeSelector]("required")
      } yield VolumeNodeAffinity (
          required = required
        )
    }
}

