package io.k8s.api.flowcontrol.v1beta3

import dev.hnaderi.k8s.utils._

/** ExemptPriorityLevelConfiguration describes the configurable aspects of the handling of exempt requests. In the mandatory exempt configuration object the values in the fields here can be modified by authorized users, unlike the rest of the `spec`. */
final case class ExemptPriorityLevelConfiguration(
  lendablePercent : Option[Int] = None,
  nominalConcurrencyShares : Option[Int] = None
) {

  /** Returns a new data with lendablePercent set to new value */
  def withLendablePercent(value: Int) : ExemptPriorityLevelConfiguration = copy(lendablePercent = Some(value))
  /** if lendablePercent has a value, transforms to the result of function*/
  def mapLendablePercent(f: Int => Int) : ExemptPriorityLevelConfiguration = copy(lendablePercent = lendablePercent.map(f))

  /** Returns a new data with nominalConcurrencyShares set to new value */
  def withNominalConcurrencyShares(value: Int) : ExemptPriorityLevelConfiguration = copy(nominalConcurrencyShares = Some(value))
  /** if nominalConcurrencyShares has a value, transforms to the result of function*/
  def mapNominalConcurrencyShares(f: Int => Int) : ExemptPriorityLevelConfiguration = copy(nominalConcurrencyShares = nominalConcurrencyShares.map(f))
}

object ExemptPriorityLevelConfiguration {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta3.ExemptPriorityLevelConfiguration] = new Encoder[io.k8s.api.flowcontrol.v1beta3.ExemptPriorityLevelConfiguration] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta3.ExemptPriorityLevelConfiguration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("lendablePercent", o.lendablePercent)
            .write("nominalConcurrencyShares", o.nominalConcurrencyShares)
            .build
        }
    }

    implicit val decoder: Decoder[ExemptPriorityLevelConfiguration] = new Decoder[ExemptPriorityLevelConfiguration] {
      def apply[T : Reader](t: T): Either[String, ExemptPriorityLevelConfiguration] = for {
          obj <- ObjectReader(t)
          lendablePercent <- obj.readOpt[Int]("lendablePercent")
          nominalConcurrencyShares <- obj.readOpt[Int]("nominalConcurrencyShares")
      } yield ExemptPriorityLevelConfiguration (
          lendablePercent = lendablePercent,
          nominalConcurrencyShares = nominalConcurrencyShares
        )
    }
}

