package io.k8s.api.flowcontrol.v1beta3

import dev.hnaderi.k8s.utils._

/** PriorityLevelConfigurationStatus represents the current state of a "request-priority". */
final case class PriorityLevelConfigurationStatus(
  conditions : Option[Seq[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationCondition]] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationCondition]) : PriorityLevelConfigurationStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationCondition*) : PriorityLevelConfigurationStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationCondition] => Seq[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationCondition]) : PriorityLevelConfigurationStatus = copy(conditions = conditions.map(f))
}

object PriorityLevelConfigurationStatus {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationStatus] = new Encoder[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationStatus] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .build
        }
    }

    implicit val decoder: Decoder[PriorityLevelConfigurationStatus] = new Decoder[PriorityLevelConfigurationStatus] {
      def apply[T : Reader](t: T): Either[String, PriorityLevelConfigurationStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationCondition]]("conditions")
      } yield PriorityLevelConfigurationStatus (
          conditions = conditions
        )
    }
}

