package io.k8s.api.flowcontrol.v1beta3

import dev.hnaderi.k8s.utils._

/** Subject matches the originator of a request, as identified by the request authentication system. There are three ways of matching an originator; by user, group, or service account. */
final case class Subject(
  kind : String,
  group : Option[io.k8s.api.flowcontrol.v1beta3.GroupSubject] = None,
  serviceAccount : Option[io.k8s.api.flowcontrol.v1beta3.ServiceAccountSubject] = None,
  user : Option[io.k8s.api.flowcontrol.v1beta3.UserSubject] = None
) {

  /** Returns a new data with kind set to new value */
  def withKind(value: String) : Subject = copy(kind = value)
  /** transforms kind to result of function */
  def mapKind(f: String => String) : Subject = copy(kind = f(kind))

  /** Returns a new data with group set to new value */
  def withGroup(value: io.k8s.api.flowcontrol.v1beta3.GroupSubject) : Subject = copy(group = Some(value))
  /** if group has a value, transforms to the result of function*/
  def mapGroup(f: io.k8s.api.flowcontrol.v1beta3.GroupSubject => io.k8s.api.flowcontrol.v1beta3.GroupSubject) : Subject = copy(group = group.map(f))

  /** Returns a new data with serviceAccount set to new value */
  def withServiceAccount(value: io.k8s.api.flowcontrol.v1beta3.ServiceAccountSubject) : Subject = copy(serviceAccount = Some(value))
  /** if serviceAccount has a value, transforms to the result of function*/
  def mapServiceAccount(f: io.k8s.api.flowcontrol.v1beta3.ServiceAccountSubject => io.k8s.api.flowcontrol.v1beta3.ServiceAccountSubject) : Subject = copy(serviceAccount = serviceAccount.map(f))

  /** Returns a new data with user set to new value */
  def withUser(value: io.k8s.api.flowcontrol.v1beta3.UserSubject) : Subject = copy(user = Some(value))
  /** if user has a value, transforms to the result of function*/
  def mapUser(f: io.k8s.api.flowcontrol.v1beta3.UserSubject => io.k8s.api.flowcontrol.v1beta3.UserSubject) : Subject = copy(user = user.map(f))
}

object Subject {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta3.Subject] = new Encoder[io.k8s.api.flowcontrol.v1beta3.Subject] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta3.Subject) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("kind", o.kind)
            .write("group", o.group)
            .write("serviceAccount", o.serviceAccount)
            .write("user", o.user)
            .build
        }
    }

    implicit val decoder: Decoder[Subject] = new Decoder[Subject] {
      def apply[T : Reader](t: T): Either[String, Subject] = for {
          obj <- ObjectReader(t)
          kind <- obj.read[String]("kind")
          group <- obj.readOpt[io.k8s.api.flowcontrol.v1beta3.GroupSubject]("group")
          serviceAccount <- obj.readOpt[io.k8s.api.flowcontrol.v1beta3.ServiceAccountSubject]("serviceAccount")
          user <- obj.readOpt[io.k8s.api.flowcontrol.v1beta3.UserSubject]("user")
      } yield Subject (
          kind = kind,
          group = group,
          serviceAccount = serviceAccount,
          user = user
        )
    }
}

