package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** IngressPortStatus represents the error condition of a service port */
final case class IngressPortStatus(
  port : Int,
  protocol : String,
  error : Option[String] = None
) {

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : IngressPortStatus = copy(port = value)
  /** transforms port to result of function */
  def mapPort(f: Int => Int) : IngressPortStatus = copy(port = f(port))

  /** Returns a new data with protocol set to new value */
  def withProtocol(value: String) : IngressPortStatus = copy(protocol = value)
  /** transforms protocol to result of function */
  def mapProtocol(f: String => String) : IngressPortStatus = copy(protocol = f(protocol))

  /** Returns a new data with error set to new value */
  def withError(value: String) : IngressPortStatus = copy(error = Some(value))
  /** if error has a value, transforms to the result of function*/
  def mapError(f: String => String) : IngressPortStatus = copy(error = error.map(f))
}

object IngressPortStatus {

    implicit val encoder : Encoder[io.k8s.api.networking.v1.IngressPortStatus] = new Encoder[io.k8s.api.networking.v1.IngressPortStatus] {
        def apply[T : Builder](o: io.k8s.api.networking.v1.IngressPortStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("port", o.port)
            .write("protocol", o.protocol)
            .write("error", o.error)
            .build
        }
    }

    implicit val decoder: Decoder[IngressPortStatus] = new Decoder[IngressPortStatus] {
      def apply[T : Reader](t: T): Either[String, IngressPortStatus] = for {
          obj <- ObjectReader(t)
          port <- obj.read[Int]("port")
          protocol <- obj.read[String]("protocol")
          error <- obj.readOpt[String]("error")
      } yield IngressPortStatus (
          port = port,
          protocol = protocol,
          error = error
        )
    }
}

