package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s.utils._

/** ServiceCIDRStatus describes the current state of the ServiceCIDR. */
final case class ServiceCIDRStatus(
  conditions : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : ServiceCIDRStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.Condition*) : ServiceCIDRStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : ServiceCIDRStatus = copy(conditions = conditions.map(f))
}

object ServiceCIDRStatus {

    implicit val encoder : Encoder[io.k8s.api.networking.v1alpha1.ServiceCIDRStatus] = new Encoder[io.k8s.api.networking.v1alpha1.ServiceCIDRStatus] {
        def apply[T : Builder](o: io.k8s.api.networking.v1alpha1.ServiceCIDRStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .build
        }
    }

    implicit val decoder: Decoder[ServiceCIDRStatus] = new Decoder[ServiceCIDRStatus] {
      def apply[T : Reader](t: T): Either[String, ServiceCIDRStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]]("conditions")
      } yield ServiceCIDRStatus (
          conditions = conditions
        )
    }
}

