package io.k8s.api.policy.v1

import dev.hnaderi.k8s.utils._

/** PodDisruptionBudgetSpec is a description of a PodDisruptionBudget. */
final case class PodDisruptionBudgetSpec(
  maxUnavailable : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  minAvailable : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  unhealthyPodEvictionPolicy : Option[String] = None
) {

  /** Returns a new data with maxUnavailable set to new value */
  def withMaxUnavailable(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : PodDisruptionBudgetSpec = copy(maxUnavailable = Some(value))
  /** if maxUnavailable has a value, transforms to the result of function*/
  def mapMaxUnavailable(f: io.k8s.apimachinery.pkg.util.intstr.IntOrString => io.k8s.apimachinery.pkg.util.intstr.IntOrString) : PodDisruptionBudgetSpec = copy(maxUnavailable = maxUnavailable.map(f))

  /** Returns a new data with minAvailable set to new value */
  def withMinAvailable(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : PodDisruptionBudgetSpec = copy(minAvailable = Some(value))
  /** if minAvailable has a value, transforms to the result of function*/
  def mapMinAvailable(f: io.k8s.apimachinery.pkg.util.intstr.IntOrString => io.k8s.apimachinery.pkg.util.intstr.IntOrString) : PodDisruptionBudgetSpec = copy(minAvailable = minAvailable.map(f))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : PodDisruptionBudgetSpec = copy(selector = Some(value))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : PodDisruptionBudgetSpec = copy(selector = selector.map(f))

  /** Returns a new data with unhealthyPodEvictionPolicy set to new value */
  def withUnhealthyPodEvictionPolicy(value: String) : PodDisruptionBudgetSpec = copy(unhealthyPodEvictionPolicy = Some(value))
  /** if unhealthyPodEvictionPolicy has a value, transforms to the result of function*/
  def mapUnhealthyPodEvictionPolicy(f: String => String) : PodDisruptionBudgetSpec = copy(unhealthyPodEvictionPolicy = unhealthyPodEvictionPolicy.map(f))
}

object PodDisruptionBudgetSpec {

    implicit val encoder : Encoder[io.k8s.api.policy.v1.PodDisruptionBudgetSpec] = new Encoder[io.k8s.api.policy.v1.PodDisruptionBudgetSpec] {
        def apply[T : Builder](o: io.k8s.api.policy.v1.PodDisruptionBudgetSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("maxUnavailable", o.maxUnavailable)
            .write("minAvailable", o.minAvailable)
            .write("selector", o.selector)
            .write("unhealthyPodEvictionPolicy", o.unhealthyPodEvictionPolicy)
            .build
        }
    }

    implicit val decoder: Decoder[PodDisruptionBudgetSpec] = new Decoder[PodDisruptionBudgetSpec] {
      def apply[T : Reader](t: T): Either[String, PodDisruptionBudgetSpec] = for {
          obj <- ObjectReader(t)
          maxUnavailable <- obj.readOpt[io.k8s.apimachinery.pkg.util.intstr.IntOrString]("maxUnavailable")
          minAvailable <- obj.readOpt[io.k8s.apimachinery.pkg.util.intstr.IntOrString]("minAvailable")
          selector <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("selector")
          unhealthyPodEvictionPolicy <- obj.readOpt[String]("unhealthyPodEvictionPolicy")
      } yield PodDisruptionBudgetSpec (
          maxUnavailable = maxUnavailable,
          minAvailable = minAvailable,
          selector = selector,
          unhealthyPodEvictionPolicy = unhealthyPodEvictionPolicy
        )
    }
}

