package io.k8s.api.rbac.v1

import dev.hnaderi.k8s.utils._

/** RoleRef contains information that points to the role being used */
final case class RoleRef(
  apiGroup : String,
  kind : String,
  name : String
) {

  /** Returns a new data with apiGroup set to new value */
  def withApiGroup(value: String) : RoleRef = copy(apiGroup = value)
  /** transforms apiGroup to result of function */
  def mapApiGroup(f: String => String) : RoleRef = copy(apiGroup = f(apiGroup))

  /** Returns a new data with kind set to new value */
  def withKind(value: String) : RoleRef = copy(kind = value)
  /** transforms kind to result of function */
  def mapKind(f: String => String) : RoleRef = copy(kind = f(kind))

  /** Returns a new data with name set to new value */
  def withName(value: String) : RoleRef = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : RoleRef = copy(name = f(name))
}

object RoleRef {

    implicit val encoder : Encoder[io.k8s.api.rbac.v1.RoleRef] = new Encoder[io.k8s.api.rbac.v1.RoleRef] {
        def apply[T : Builder](o: io.k8s.api.rbac.v1.RoleRef) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("apiGroup", o.apiGroup)
            .write("kind", o.kind)
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[RoleRef] = new Decoder[RoleRef] {
      def apply[T : Reader](t: T): Either[String, RoleRef] = for {
          obj <- ObjectReader(t)
          apiGroup <- obj.read[String]("apiGroup")
          kind <- obj.read[String]("kind")
          name <- obj.read[String]("name")
      } yield RoleRef (
          apiGroup = apiGroup,
          kind = kind,
          name = name
        )
    }
}

