package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** DriverAllocationResult contains vendor parameters and the allocation result for one request. */
final case class DriverAllocationResult(
  namedResources : Option[io.k8s.api.resource.v1alpha2.NamedResourcesAllocationResult] = None,
  vendorRequestParameters : Option[io.k8s.apimachinery.pkg.runtime.RawExtension] = None
) {

  /** Returns a new data with namedResources set to new value */
  def withNamedResources(value: io.k8s.api.resource.v1alpha2.NamedResourcesAllocationResult) : DriverAllocationResult = copy(namedResources = Some(value))
  /** if namedResources has a value, transforms to the result of function*/
  def mapNamedResources(f: io.k8s.api.resource.v1alpha2.NamedResourcesAllocationResult => io.k8s.api.resource.v1alpha2.NamedResourcesAllocationResult) : DriverAllocationResult = copy(namedResources = namedResources.map(f))

  /** Returns a new data with vendorRequestParameters set to new value */
  def withVendorRequestParameters(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : DriverAllocationResult = copy(vendorRequestParameters = Some(value))
  /** if vendorRequestParameters has a value, transforms to the result of function*/
  def mapVendorRequestParameters(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : DriverAllocationResult = copy(vendorRequestParameters = vendorRequestParameters.map(f))
}

object DriverAllocationResult {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.DriverAllocationResult] = new Encoder[io.k8s.api.resource.v1alpha2.DriverAllocationResult] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.DriverAllocationResult) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("namedResources", o.namedResources)
            .write("vendorRequestParameters", o.vendorRequestParameters)
            .build
        }
    }

    implicit val decoder: Decoder[DriverAllocationResult] = new Decoder[DriverAllocationResult] {
      def apply[T : Reader](t: T): Either[String, DriverAllocationResult] = for {
          obj <- ObjectReader(t)
          namedResources <- obj.readOpt[io.k8s.api.resource.v1alpha2.NamedResourcesAllocationResult]("namedResources")
          vendorRequestParameters <- obj.readOpt[io.k8s.apimachinery.pkg.runtime.RawExtension]("vendorRequestParameters")
      } yield DriverAllocationResult (
          namedResources = namedResources,
          vendorRequestParameters = vendorRequestParameters
        )
    }
}

