package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** DriverRequests describes all resources that are needed from one particular driver. */
final case class DriverRequests(
  driverName : Option[String] = None,
  requests : Option[Seq[io.k8s.api.resource.v1alpha2.ResourceRequest]] = None,
  vendorParameters : Option[io.k8s.apimachinery.pkg.runtime.RawExtension] = None
) {

  /** Returns a new data with driverName set to new value */
  def withDriverName(value: String) : DriverRequests = copy(driverName = Some(value))
  /** if driverName has a value, transforms to the result of function*/
  def mapDriverName(f: String => String) : DriverRequests = copy(driverName = driverName.map(f))

  /** Returns a new data with requests set to new value */
  def withRequests(value: Seq[io.k8s.api.resource.v1alpha2.ResourceRequest]) : DriverRequests = copy(requests = Some(value))
  /** Appends new values to requests */
  def addRequests(newValues: io.k8s.api.resource.v1alpha2.ResourceRequest*) : DriverRequests = copy(requests = Some(requests.fold(newValues)(_ ++ newValues)))
  /** if requests has a value, transforms to the result of function*/
  def mapRequests(f: Seq[io.k8s.api.resource.v1alpha2.ResourceRequest] => Seq[io.k8s.api.resource.v1alpha2.ResourceRequest]) : DriverRequests = copy(requests = requests.map(f))

  /** Returns a new data with vendorParameters set to new value */
  def withVendorParameters(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : DriverRequests = copy(vendorParameters = Some(value))
  /** if vendorParameters has a value, transforms to the result of function*/
  def mapVendorParameters(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : DriverRequests = copy(vendorParameters = vendorParameters.map(f))
}

object DriverRequests {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.DriverRequests] = new Encoder[io.k8s.api.resource.v1alpha2.DriverRequests] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.DriverRequests) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("driverName", o.driverName)
            .write("requests", o.requests)
            .write("vendorParameters", o.vendorParameters)
            .build
        }
    }

    implicit val decoder: Decoder[DriverRequests] = new Decoder[DriverRequests] {
      def apply[T : Reader](t: T): Either[String, DriverRequests] = for {
          obj <- ObjectReader(t)
          driverName <- obj.readOpt[String]("driverName")
          requests <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha2.ResourceRequest]]("requests")
          vendorParameters <- obj.readOpt[io.k8s.apimachinery.pkg.runtime.RawExtension]("vendorParameters")
      } yield DriverRequests (
          driverName = driverName,
          requests = requests,
          vendorParameters = vendorParameters
        )
    }
}

