package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** NamedResourcesFilter is used in ResourceFilterModel. */
final case class NamedResourcesFilter(
  selector : String
) {

  /** Returns a new data with selector set to new value */
  def withSelector(value: String) : NamedResourcesFilter = copy(selector = value)
  /** transforms selector to result of function */
  def mapSelector(f: String => String) : NamedResourcesFilter = copy(selector = f(selector))
}

object NamedResourcesFilter {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesFilter] = new Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesFilter] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.NamedResourcesFilter) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("selector", o.selector)
            .build
        }
    }

    implicit val decoder: Decoder[NamedResourcesFilter] = new Decoder[NamedResourcesFilter] {
      def apply[T : Reader](t: T): Either[String, NamedResourcesFilter] = for {
          obj <- ObjectReader(t)
          selector <- obj.read[String]("selector")
      } yield NamedResourcesFilter (
          selector = selector
        )
    }
}

