package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** NamedResourcesStringSlice contains a slice of strings. */
final case class NamedResourcesStringSlice(
  strings : Seq[String]
) {

  /** Returns a new data with strings set to new value */
  def withStrings(value: Seq[String]) : NamedResourcesStringSlice = copy(strings = value)
  /** Appends new values to strings */
  def addStrings(newValues: String*) : NamedResourcesStringSlice = copy(strings = strings ++ newValues)
  /** transforms strings to result of function */
  def mapStrings(f: Seq[String] => Seq[String]) : NamedResourcesStringSlice = copy(strings = f(strings))
}

object NamedResourcesStringSlice {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesStringSlice] = new Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesStringSlice] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.NamedResourcesStringSlice) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("strings", o.strings)
            .build
        }
    }

    implicit val decoder: Decoder[NamedResourcesStringSlice] = new Decoder[NamedResourcesStringSlice] {
      def apply[T : Reader](t: T): Either[String, NamedResourcesStringSlice] = for {
          obj <- ObjectReader(t)
          strings <- obj.read[Seq[String]]("strings")
      } yield NamedResourcesStringSlice (
          strings = strings
        )
    }
}

