package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PodSchedulingContext objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

This is an alpha type and requires enabling the DynamicResourceAllocation feature gate. */
final case class PodSchedulingContext(
  spec : io.k8s.api.resource.v1alpha2.PodSchedulingContextSpec,
  status : Option[io.k8s.api.resource.v1alpha2.PodSchedulingContextStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "PodSchedulingContext", "v1alpha2")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.resource.v1alpha2.PodSchedulingContextSpec) : PodSchedulingContext = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.resource.v1alpha2.PodSchedulingContextSpec => io.k8s.api.resource.v1alpha2.PodSchedulingContextSpec) : PodSchedulingContext = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.resource.v1alpha2.PodSchedulingContextStatus) : PodSchedulingContext = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.resource.v1alpha2.PodSchedulingContextStatus => io.k8s.api.resource.v1alpha2.PodSchedulingContextStatus) : PodSchedulingContext = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodSchedulingContext = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodSchedulingContext = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PodSchedulingContext.encoder.apply(this)
}

object PodSchedulingContext {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.PodSchedulingContext] = new Encoder[io.k8s.api.resource.v1alpha2.PodSchedulingContext] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.PodSchedulingContext) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("status", o.status)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PodSchedulingContext] = new Decoder[PodSchedulingContext] {
      def apply[T : Reader](t: T): Either[String, PodSchedulingContext] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.resource.v1alpha2.PodSchedulingContextSpec]("spec")
          status <- obj.readOpt[io.k8s.api.resource.v1alpha2.PodSchedulingContextStatus]("status")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield PodSchedulingContext (
          spec = spec,
          status = status,
          metadata = metadata
        )
    }
}

