package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim. */
final case class ResourceClaimParametersReference(
  kind : String,
  name : String,
  apiGroup : Option[String] = None
) {

  /** Returns a new data with kind set to new value */
  def withKind(value: String) : ResourceClaimParametersReference = copy(kind = value)
  /** transforms kind to result of function */
  def mapKind(f: String => String) : ResourceClaimParametersReference = copy(kind = f(kind))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourceClaimParametersReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ResourceClaimParametersReference = copy(name = f(name))

  /** Returns a new data with apiGroup set to new value */
  def withApiGroup(value: String) : ResourceClaimParametersReference = copy(apiGroup = Some(value))
  /** if apiGroup has a value, transforms to the result of function*/
  def mapApiGroup(f: String => String) : ResourceClaimParametersReference = copy(apiGroup = apiGroup.map(f))
}

object ResourceClaimParametersReference {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimParametersReference] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimParametersReference] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceClaimParametersReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("kind", o.kind)
            .write("name", o.name)
            .write("apiGroup", o.apiGroup)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimParametersReference] = new Decoder[ResourceClaimParametersReference] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimParametersReference] = for {
          obj <- ObjectReader(t)
          kind <- obj.read[String]("kind")
          name <- obj.read[String]("name")
          apiGroup <- obj.readOpt[String]("apiGroup")
      } yield ResourceClaimParametersReference (
          kind = kind,
          name = name,
          apiGroup = apiGroup
        )
    }
}

