package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode. */
final case class ResourceClaimSchedulingStatus(
  name : Option[String] = None,
  unsuitableNodes : Option[Seq[String]] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourceClaimSchedulingStatus = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ResourceClaimSchedulingStatus = copy(name = name.map(f))

  /** Returns a new data with unsuitableNodes set to new value */
  def withUnsuitableNodes(value: Seq[String]) : ResourceClaimSchedulingStatus = copy(unsuitableNodes = Some(value))
  /** Appends new values to unsuitableNodes */
  def addUnsuitableNodes(newValues: String*) : ResourceClaimSchedulingStatus = copy(unsuitableNodes = Some(unsuitableNodes.fold(newValues)(_ ++ newValues)))
  /** if unsuitableNodes has a value, transforms to the result of function*/
  def mapUnsuitableNodes(f: Seq[String] => Seq[String]) : ResourceClaimSchedulingStatus = copy(unsuitableNodes = unsuitableNodes.map(f))
}

object ResourceClaimSchedulingStatus {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("unsuitableNodes", o.unsuitableNodes)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimSchedulingStatus] = new Decoder[ResourceClaimSchedulingStatus] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimSchedulingStatus] = for {
          obj <- ObjectReader(t)
          name <- obj.readOpt[String]("name")
          unsuitableNodes <- obj.readOpt[Seq[String]]("unsuitableNodes")
      } yield ResourceClaimSchedulingStatus (
          name = name,
          unsuitableNodes = unsuitableNodes
        )
    }
}

