package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceClassParametersList is a collection of ResourceClassParameters. */
final case class ResourceClassParametersList(
  items : Seq[io.k8s.api.resource.v1alpha2.ResourceClassParameters],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceClassParametersList", "v1alpha2")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.resource.v1alpha2.ResourceClassParameters]) : ResourceClassParametersList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.resource.v1alpha2.ResourceClassParameters*) : ResourceClassParametersList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.resource.v1alpha2.ResourceClassParameters] => Seq[io.k8s.api.resource.v1alpha2.ResourceClassParameters]) : ResourceClassParametersList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceClassParametersList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceClassParametersList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceClassParametersList.encoder.apply(this)
}

object ResourceClassParametersList {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceClassParametersList] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceClassParametersList] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceClassParametersList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClassParametersList] = new Decoder[ResourceClassParametersList] {
      def apply[T : Reader](t: T): Either[String, ResourceClassParametersList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.resource.v1alpha2.ResourceClassParameters]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ResourceClassParametersList (
          items = items,
          metadata = metadata
        )
    }
}

