package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** ResourceRequest is a request for resources from one particular driver. */
final case class ResourceRequest(
  namedResources : Option[io.k8s.api.resource.v1alpha2.NamedResourcesRequest] = None,
  vendorParameters : Option[io.k8s.apimachinery.pkg.runtime.RawExtension] = None
) {

  /** Returns a new data with namedResources set to new value */
  def withNamedResources(value: io.k8s.api.resource.v1alpha2.NamedResourcesRequest) : ResourceRequest = copy(namedResources = Some(value))
  /** if namedResources has a value, transforms to the result of function*/
  def mapNamedResources(f: io.k8s.api.resource.v1alpha2.NamedResourcesRequest => io.k8s.api.resource.v1alpha2.NamedResourcesRequest) : ResourceRequest = copy(namedResources = namedResources.map(f))

  /** Returns a new data with vendorParameters set to new value */
  def withVendorParameters(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : ResourceRequest = copy(vendorParameters = Some(value))
  /** if vendorParameters has a value, transforms to the result of function*/
  def mapVendorParameters(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : ResourceRequest = copy(vendorParameters = vendorParameters.map(f))
}

object ResourceRequest {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceRequest] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceRequest] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceRequest) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("namedResources", o.namedResources)
            .write("vendorParameters", o.vendorParameters)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceRequest] = new Decoder[ResourceRequest] {
      def apply[T : Reader](t: T): Either[String, ResourceRequest] = for {
          obj <- ObjectReader(t)
          namedResources <- obj.readOpt[io.k8s.api.resource.v1alpha2.NamedResourcesRequest]("namedResources")
          vendorParameters <- obj.readOpt[io.k8s.apimachinery.pkg.runtime.RawExtension]("vendorParameters")
      } yield ResourceRequest (
          namedResources = namedResources,
          vendorParameters = vendorParameters
        )
    }
}

