package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceSlice provides information about available resources on individual nodes. */
final case class ResourceSlice(
  driverName : String,
  nodeName : Option[String] = None,
  namedResources : Option[io.k8s.api.resource.v1alpha2.NamedResourcesResources] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceSlice", "v1alpha2")


  /** Returns a new data with driverName set to new value */
  def withDriverName(value: String) : ResourceSlice = copy(driverName = value)
  /** transforms driverName to result of function */
  def mapDriverName(f: String => String) : ResourceSlice = copy(driverName = f(driverName))

  /** Returns a new data with nodeName set to new value */
  def withNodeName(value: String) : ResourceSlice = copy(nodeName = Some(value))
  /** if nodeName has a value, transforms to the result of function*/
  def mapNodeName(f: String => String) : ResourceSlice = copy(nodeName = nodeName.map(f))

  /** Returns a new data with namedResources set to new value */
  def withNamedResources(value: io.k8s.api.resource.v1alpha2.NamedResourcesResources) : ResourceSlice = copy(namedResources = Some(value))
  /** if namedResources has a value, transforms to the result of function*/
  def mapNamedResources(f: io.k8s.api.resource.v1alpha2.NamedResourcesResources => io.k8s.api.resource.v1alpha2.NamedResourcesResources) : ResourceSlice = copy(namedResources = namedResources.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceSlice = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceSlice = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ResourceSlice.encoder.apply(this)
}

object ResourceSlice {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceSlice] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceSlice] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceSlice) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("driverName", o.driverName)
            .write("nodeName", o.nodeName)
            .write("namedResources", o.namedResources)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceSlice] = new Decoder[ResourceSlice] {
      def apply[T : Reader](t: T): Either[String, ResourceSlice] = for {
          obj <- ObjectReader(t)
          driverName <- obj.read[String]("driverName")
          nodeName <- obj.readOpt[String]("nodeName")
          namedResources <- obj.readOpt[io.k8s.api.resource.v1alpha2.NamedResourcesResources]("namedResources")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ResourceSlice (
          driverName = driverName,
          nodeName = nodeName,
          namedResources = namedResources,
          metadata = metadata
        )
    }
}

