package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** VendorParameters are opaque parameters for one particular driver. */
final case class VendorParameters(
  driverName : Option[String] = None,
  parameters : Option[io.k8s.apimachinery.pkg.runtime.RawExtension] = None
) {

  /** Returns a new data with driverName set to new value */
  def withDriverName(value: String) : VendorParameters = copy(driverName = Some(value))
  /** if driverName has a value, transforms to the result of function*/
  def mapDriverName(f: String => String) : VendorParameters = copy(driverName = driverName.map(f))

  /** Returns a new data with parameters set to new value */
  def withParameters(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : VendorParameters = copy(parameters = Some(value))
  /** if parameters has a value, transforms to the result of function*/
  def mapParameters(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : VendorParameters = copy(parameters = parameters.map(f))
}

object VendorParameters {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.VendorParameters] = new Encoder[io.k8s.api.resource.v1alpha2.VendorParameters] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.VendorParameters) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("driverName", o.driverName)
            .write("parameters", o.parameters)
            .build
        }
    }

    implicit val decoder: Decoder[VendorParameters] = new Decoder[VendorParameters] {
      def apply[T : Reader](t: T): Either[String, VendorParameters] = for {
          obj <- ObjectReader(t)
          driverName <- obj.readOpt[String]("driverName")
          parameters <- obj.readOpt[io.k8s.apimachinery.pkg.runtime.RawExtension]("parameters")
      } yield VendorParameters (
          driverName = driverName,
          parameters = parameters
        )
    }
}

