package io.k8s.api.storage.v1

import dev.hnaderi.k8s.utils._

/** VolumeNodeResources is a set of resource limits for scheduling of volumes. */
final case class VolumeNodeResources(
  count : Option[Int] = None
) {

  /** Returns a new data with count set to new value */
  def withCount(value: Int) : VolumeNodeResources = copy(count = Some(value))
  /** if count has a value, transforms to the result of function*/
  def mapCount(f: Int => Int) : VolumeNodeResources = copy(count = count.map(f))
}

object VolumeNodeResources {

    implicit val encoder : Encoder[io.k8s.api.storage.v1.VolumeNodeResources] = new Encoder[io.k8s.api.storage.v1.VolumeNodeResources] {
        def apply[T : Builder](o: io.k8s.api.storage.v1.VolumeNodeResources) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("count", o.count)
            .build
        }
    }

    implicit val decoder: Decoder[VolumeNodeResources] = new Decoder[VolumeNodeResources] {
      def apply[T : Reader](t: T): Either[String, VolumeNodeResources] = for {
          obj <- ObjectReader(t)
          count <- obj.readOpt[Int]("count")
      } yield VolumeNodeResources (
          count = count
        )
    }
}

