package io.k8s.api.storage.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** VolumeAttributesClassList is a collection of VolumeAttributesClass objects. */
final case class VolumeAttributesClassList(
  items : Seq[io.k8s.api.storage.v1alpha1.VolumeAttributesClass],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "VolumeAttributesClassList", "v1alpha1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.storage.v1alpha1.VolumeAttributesClass]) : VolumeAttributesClassList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.storage.v1alpha1.VolumeAttributesClass*) : VolumeAttributesClassList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.storage.v1alpha1.VolumeAttributesClass] => Seq[io.k8s.api.storage.v1alpha1.VolumeAttributesClass]) : VolumeAttributesClassList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : VolumeAttributesClassList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : VolumeAttributesClassList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = VolumeAttributesClassList.encoder.apply(this)
}

object VolumeAttributesClassList {

    implicit val encoder : Encoder[io.k8s.api.storage.v1alpha1.VolumeAttributesClassList] = new Encoder[io.k8s.api.storage.v1alpha1.VolumeAttributesClassList] {
        def apply[T : Builder](o: io.k8s.api.storage.v1alpha1.VolumeAttributesClassList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[VolumeAttributesClassList] = new Decoder[VolumeAttributesClassList] {
      def apply[T : Reader](t: T): Either[String, VolumeAttributesClassList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.storage.v1alpha1.VolumeAttributesClass]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield VolumeAttributesClassList (
          items = items,
          metadata = metadata
        )
    }
}

