package io.k8s.api.storagemigration.v1alpha1

import dev.hnaderi.k8s.utils._

/** The names of the group, the version, and the resource. */
final case class GroupVersionResource(
  group : Option[String] = None,
  resource : Option[String] = None,
  version : Option[String] = None
) {

  /** Returns a new data with group set to new value */
  def withGroup(value: String) : GroupVersionResource = copy(group = Some(value))
  /** if group has a value, transforms to the result of function*/
  def mapGroup(f: String => String) : GroupVersionResource = copy(group = group.map(f))

  /** Returns a new data with resource set to new value */
  def withResource(value: String) : GroupVersionResource = copy(resource = Some(value))
  /** if resource has a value, transforms to the result of function*/
  def mapResource(f: String => String) : GroupVersionResource = copy(resource = resource.map(f))

  /** Returns a new data with version set to new value */
  def withVersion(value: String) : GroupVersionResource = copy(version = Some(value))
  /** if version has a value, transforms to the result of function*/
  def mapVersion(f: String => String) : GroupVersionResource = copy(version = version.map(f))
}

object GroupVersionResource {

    implicit val encoder : Encoder[io.k8s.api.storagemigration.v1alpha1.GroupVersionResource] = new Encoder[io.k8s.api.storagemigration.v1alpha1.GroupVersionResource] {
        def apply[T : Builder](o: io.k8s.api.storagemigration.v1alpha1.GroupVersionResource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("group", o.group)
            .write("resource", o.resource)
            .write("version", o.version)
            .build
        }
    }

    implicit val decoder: Decoder[GroupVersionResource] = new Decoder[GroupVersionResource] {
      def apply[T : Reader](t: T): Either[String, GroupVersionResource] = for {
          obj <- ObjectReader(t)
          group <- obj.readOpt[String]("group")
          resource <- obj.readOpt[String]("resource")
          version <- obj.readOpt[String]("version")
      } yield GroupVersionResource (
          group = group,
          resource = resource,
          version = version
        )
    }
}

