package io.k8s.api.storagemigration.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** StorageVersionMigration represents a migration of stored data to the latest storage version. */
final case class StorageVersionMigration(
  status : Option[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationStatus] = None,
  spec : Option[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storagemigration.k8s.io", "StorageVersionMigration", "v1alpha1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationStatus) : StorageVersionMigration = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationStatus => io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationStatus) : StorageVersionMigration = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationSpec) : StorageVersionMigration = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationSpec => io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationSpec) : StorageVersionMigration = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : StorageVersionMigration = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : StorageVersionMigration = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = StorageVersionMigration.encoder.apply(this)
}

object StorageVersionMigration {

    implicit val encoder : Encoder[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigration] = new Encoder[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigration] {
        def apply[T : Builder](o: io.k8s.api.storagemigration.v1alpha1.StorageVersionMigration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[StorageVersionMigration] = new Decoder[StorageVersionMigration] {
      def apply[T : Reader](t: T): Either[String, StorageVersionMigration] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationStatus]("status")
          spec <- obj.readOpt[io.k8s.api.storagemigration.v1alpha1.StorageVersionMigrationSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield StorageVersionMigration (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

