package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** CustomResourceDefinitionVersion describes a version for CRD. */
final case class CustomResourceDefinitionVersion(
  name : String,
  served : Boolean,
  storage : Boolean,
  deprecationWarning : Option[String] = None,
  deprecated : Option[Boolean] = None,
  selectableFields : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField]] = None,
  subresources : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources] = None,
  schema : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation] = None,
  additionalPrinterColumns : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : CustomResourceDefinitionVersion = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : CustomResourceDefinitionVersion = copy(name = f(name))

  /** Returns a new data with served set to new value */
  def withServed(value: Boolean) : CustomResourceDefinitionVersion = copy(served = value)
  /** transforms served to result of function */
  def mapServed(f: Boolean => Boolean) : CustomResourceDefinitionVersion = copy(served = f(served))

  /** Returns a new data with storage set to new value */
  def withStorage(value: Boolean) : CustomResourceDefinitionVersion = copy(storage = value)
  /** transforms storage to result of function */
  def mapStorage(f: Boolean => Boolean) : CustomResourceDefinitionVersion = copy(storage = f(storage))

  /** Returns a new data with deprecationWarning set to new value */
  def withDeprecationWarning(value: String) : CustomResourceDefinitionVersion = copy(deprecationWarning = Some(value))
  /** if deprecationWarning has a value, transforms to the result of function*/
  def mapDeprecationWarning(f: String => String) : CustomResourceDefinitionVersion = copy(deprecationWarning = deprecationWarning.map(f))

  /** Returns a new data with deprecated set to new value */
  def withDeprecated(value: Boolean) : CustomResourceDefinitionVersion = copy(deprecated = Some(value))
  /** if deprecated has a value, transforms to the result of function*/
  def mapDeprecated(f: Boolean => Boolean) : CustomResourceDefinitionVersion = copy(deprecated = deprecated.map(f))

  /** Returns a new data with selectableFields set to new value */
  def withSelectableFields(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField]) : CustomResourceDefinitionVersion = copy(selectableFields = Some(value))
  /** Appends new values to selectableFields */
  def addSelectableFields(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField*) : CustomResourceDefinitionVersion = copy(selectableFields = Some(selectableFields.fold(newValues)(_ ++ newValues)))
  /** if selectableFields has a value, transforms to the result of function*/
  def mapSelectableFields(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField]) : CustomResourceDefinitionVersion = copy(selectableFields = selectableFields.map(f))

  /** Returns a new data with subresources set to new value */
  def withSubresources(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources) : CustomResourceDefinitionVersion = copy(subresources = Some(value))
  /** if subresources has a value, transforms to the result of function*/
  def mapSubresources(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources) : CustomResourceDefinitionVersion = copy(subresources = subresources.map(f))

  /** Returns a new data with schema set to new value */
  def withSchema(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation) : CustomResourceDefinitionVersion = copy(schema = Some(value))
  /** if schema has a value, transforms to the result of function*/
  def mapSchema(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation) : CustomResourceDefinitionVersion = copy(schema = schema.map(f))

  /** Returns a new data with additionalPrinterColumns set to new value */
  def withAdditionalPrinterColumns(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]) : CustomResourceDefinitionVersion = copy(additionalPrinterColumns = Some(value))
  /** Appends new values to additionalPrinterColumns */
  def addAdditionalPrinterColumns(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition*) : CustomResourceDefinitionVersion = copy(additionalPrinterColumns = Some(additionalPrinterColumns.fold(newValues)(_ ++ newValues)))
  /** if additionalPrinterColumns has a value, transforms to the result of function*/
  def mapAdditionalPrinterColumns(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]) : CustomResourceDefinitionVersion = copy(additionalPrinterColumns = additionalPrinterColumns.map(f))
}

object CustomResourceDefinitionVersion {

    implicit val encoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion] {
        def apply[T : Builder](o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("served", o.served)
            .write("storage", o.storage)
            .write("deprecationWarning", o.deprecationWarning)
            .write("deprecated", o.deprecated)
            .write("selectableFields", o.selectableFields)
            .write("subresources", o.subresources)
            .write("schema", o.schema)
            .write("additionalPrinterColumns", o.additionalPrinterColumns)
            .build
        }
    }

    implicit val decoder: Decoder[CustomResourceDefinitionVersion] = new Decoder[CustomResourceDefinitionVersion] {
      def apply[T : Reader](t: T): Either[String, CustomResourceDefinitionVersion] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          served <- obj.read[Boolean]("served")
          storage <- obj.read[Boolean]("storage")
          deprecationWarning <- obj.readOpt[String]("deprecationWarning")
          deprecated <- obj.readOpt[Boolean]("deprecated")
          selectableFields <- obj.readOpt[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField]]("selectableFields")
          subresources <- obj.readOpt[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources]("subresources")
          schema <- obj.readOpt[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation]("schema")
          additionalPrinterColumns <- obj.readOpt[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]]("additionalPrinterColumns")
      } yield CustomResourceDefinitionVersion (
          name = name,
          served = served,
          storage = storage,
          deprecationWarning = deprecationWarning,
          deprecated = deprecated,
          selectableFields = selectableFields,
          subresources = subresources,
          schema = schema,
          additionalPrinterColumns = additionalPrinterColumns
        )
    }
}

