package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** CustomResourceSubresources defines the status and scale subresources for CustomResources. */
final case class CustomResourceSubresources(
  scale : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale] = None,
  status : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceStatus] = None
) {

  /** Returns a new data with scale set to new value */
  def withScale(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale) : CustomResourceSubresources = copy(scale = Some(value))
  /** if scale has a value, transforms to the result of function*/
  def mapScale(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale) : CustomResourceSubresources = copy(scale = scale.map(f))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceStatus) : CustomResourceSubresources = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceStatus => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceStatus) : CustomResourceSubresources = copy(status = status.map(f))
}

object CustomResourceSubresources {

    implicit val encoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources] {
        def apply[T : Builder](o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("scale", o.scale)
            .write("status", o.status)
            .build
        }
    }

    implicit val decoder: Decoder[CustomResourceSubresources] = new Decoder[CustomResourceSubresources] {
      def apply[T : Reader](t: T): Either[String, CustomResourceSubresources] = for {
          obj <- ObjectReader(t)
          scale <- obj.readOpt[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale]("scale")
          status <- obj.readOpt[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceStatus]("status")
      } yield CustomResourceSubresources (
          scale = scale,
          status = status
        )
    }
}

