package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.utils._

/** GroupVersion contains the "group/version" and "version" string of a version. It is made a struct to keep extensibility. */
final case class GroupVersionForDiscovery(
  groupVersion : String,
  version : String
) {

  /** Returns a new data with groupVersion set to new value */
  def withGroupVersion(value: String) : GroupVersionForDiscovery = copy(groupVersion = value)
  /** transforms groupVersion to result of function */
  def mapGroupVersion(f: String => String) : GroupVersionForDiscovery = copy(groupVersion = f(groupVersion))

  /** Returns a new data with version set to new value */
  def withVersion(value: String) : GroupVersionForDiscovery = copy(version = value)
  /** transforms version to result of function */
  def mapVersion(f: String => String) : GroupVersionForDiscovery = copy(version = f(version))
}

object GroupVersionForDiscovery {

    implicit val encoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery] {
        def apply[T : Builder](o: io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("groupVersion", o.groupVersion)
            .write("version", o.version)
            .build
        }
    }

    implicit val decoder: Decoder[GroupVersionForDiscovery] = new Decoder[GroupVersionForDiscovery] {
      def apply[T : Reader](t: T): Either[String, GroupVersionForDiscovery] = for {
          obj <- ObjectReader(t)
          groupVersion <- obj.read[String]("groupVersion")
          version <- obj.read[String]("version")
      } yield GroupVersionForDiscovery (
          groupVersion = groupVersion,
          version = version
        )
    }
}

