package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.utils._

/** Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out. */
final case class Preconditions(
  resourceVersion : Option[String] = None,
  uid : Option[String] = None
) {

  /** Returns a new data with resourceVersion set to new value */
  def withResourceVersion(value: String) : Preconditions = copy(resourceVersion = Some(value))
  /** if resourceVersion has a value, transforms to the result of function*/
  def mapResourceVersion(f: String => String) : Preconditions = copy(resourceVersion = resourceVersion.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : Preconditions = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : Preconditions = copy(uid = uid.map(f))
}

object Preconditions {

    implicit val encoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions] {
        def apply[T : Builder](o: io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("resourceVersion", o.resourceVersion)
            .write("uid", o.uid)
            .build
        }
    }

    implicit val decoder: Decoder[Preconditions] = new Decoder[Preconditions] {
      def apply[T : Reader](t: T): Either[String, Preconditions] = for {
          obj <- ObjectReader(t)
          resourceVersion <- obj.readOpt[String]("resourceVersion")
          uid <- obj.readOpt[String]("uid")
      } yield Preconditions (
          resourceVersion = resourceVersion,
          uid = uid
        )
    }
}

