package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Status is a return value for calls that don't return other objects. */

final case class Status(
  kind: String,
  apiVersion: String,
  reason : Option[String] = None,
  code : Option[Int] = None,
  status : Option[String] = None,
  details : Option[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None,
  message : Option[String] = None
)

object Status {
  val knownKinds : Seq[ResourceKind] = Seq(
    ResourceKind("", "Status", "v1"),
    ResourceKind("resource.k8s.io", "Status", "v1alpha2")
  )


    implicit val encoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Status] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Status] {
        def apply[T : Builder](o: io.k8s.apimachinery.pkg.apis.meta.v1.Status) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("reason", o.reason)
            .write("code", o.code)
            .write("status", o.status)
            .write("details", o.details)
            .write("metadata", o.metadata)
            .write("message", o.message)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[Status] = new Decoder[Status] {
      def apply[T : Reader](t: T): Either[String, Status] = for {
          obj <- ObjectReader(t)
          apiVersion <- obj.read[String]("apiVersion")
          kind <- obj.read[String]("kind")
          reason <- obj.readOpt[String]("reason")
          code <- obj.readOpt[Int]("code")
          status <- obj.readOpt[String]("status")
          details <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails]("details")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
          message <- obj.readOpt[String]("message")
      } yield Status (
          reason = reason,
          code = code,
          status = status,
          details = details,
          metadata = metadata,
          message = message,
          apiVersion = apiVersion,
          kind = kind
        )
    }
}

