/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extensions;

import com.google.gson.JsonObject;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import net.minestom.server.extensions.ExtensionClassLoader;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiscoveredExtension {
    public static final Logger LOGGER = LoggerFactory.getLogger(DiscoveredExtension.class);
    public static final String NAME_REGEX = "[A-Za-z][_A-Za-z0-9]+";
    private String name;
    private String entrypoint;
    private String version;
    private String[] authors;
    private String[] dependencies;
    private ExternalDependencies externalDependencies;
    private JsonObject meta;
    transient List<URL> files = new LinkedList<URL>();
    transient LoadStatus loadStatus = LoadStatus.LOAD_SUCCESS;
    private transient File originalJar;
    private transient Path dataDirectory;
    private transient ExtensionClassLoader classLoader;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getEntrypoint() {
        return this.entrypoint;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public String[] getAuthors() {
        return this.authors;
    }

    @NotNull
    public String[] getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public ExternalDependencies getExternalDependencies() {
        return this.externalDependencies;
    }

    public void setOriginalJar(@Nullable File file) {
        this.originalJar = file;
    }

    @Nullable
    public File getOriginalJar() {
        return this.originalJar;
    }

    @NotNull
    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(@NotNull Path dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    void createClassLoader() {
        Check.stateCondition((this.classLoader != null ? 1 : 0) != 0, (String)"Extension classloader has already been created");
        URL[] urls = this.files.toArray(new URL[0]);
        this.classLoader = new ExtensionClassLoader(this.getName(), urls, this);
    }

    @NotNull
    public ExtensionClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static void verifyIntegrity(@NotNull DiscoveredExtension extension) {
        if (extension.name == null) {
            StringBuilder fileList = new StringBuilder();
            for (URL f : extension.files) {
                fileList.append(f.toExternalForm()).append(", ");
            }
            LOGGER.error("Extension with no name. (at {}})", (Object)fileList);
            LOGGER.error("Extension at ({}) will not be loaded.", (Object)fileList);
            extension.loadStatus = LoadStatus.INVALID_NAME;
            extension.name = extension.loadStatus.name();
            return;
        }
        if (!extension.name.matches(NAME_REGEX)) {
            LOGGER.error("Extension '{}' specified an invalid name.", (Object)extension.name);
            LOGGER.error("Extension '{}' will not be loaded.", (Object)extension.name);
            extension.loadStatus = LoadStatus.INVALID_NAME;
            extension.name = extension.loadStatus.name();
            return;
        }
        if (extension.entrypoint == null) {
            LOGGER.error("Extension '{}' did not specify an entry point (via 'entrypoint').", (Object)extension.name);
            LOGGER.error("Extension '{}' will not be loaded.", (Object)extension.name);
            extension.loadStatus = LoadStatus.NO_ENTRYPOINT;
            extension.entrypoint = extension.loadStatus.name();
            return;
        }
        if (extension.version == null) {
            LOGGER.warn("Extension '{}' did not specify a version.", (Object)extension.name);
            LOGGER.warn("Extension '{}' will continue to load but should specify a plugin version.", (Object)extension.name);
            extension.version = "Unspecified";
        }
        if (extension.authors == null) {
            extension.authors = new String[0];
        }
        if (extension.dependencies == null) {
            extension.dependencies = new String[0];
        }
        if (extension.externalDependencies == null) {
            extension.externalDependencies = new ExternalDependencies();
        }
        if (extension.meta == null) {
            extension.meta = new JsonObject();
        }
    }

    @NotNull
    public JsonObject getMeta() {
        return this.meta;
    }

    static enum LoadStatus {
        LOAD_SUCCESS("Actually, it did not fail. This message should not have been printed."),
        MISSING_DEPENDENCIES("Missing dependencies, check your logs."),
        INVALID_NAME("Invalid name."),
        NO_ENTRYPOINT("No entrypoint specified."),
        FAILED_TO_SETUP_CLASSLOADER("Extension classloader could not be setup."),
        LOAD_FAILED("Load failed. See logs for more information.");

        private final String message;

        private LoadStatus(String message) {
            this.message = message;
        }

        @NotNull
        public String getMessage() {
            return this.message;
        }
    }

    public static final class ExternalDependencies {
        Repository[] repositories = new Repository[0];
        String[] artifacts = new String[0];

        public static class Repository {
            String name = "";
            String url = "";
        }
    }
}

