/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minestom.server.ServerProcess;
import net.minestom.server.ServerProcessImpl;
import net.minestom.server.advancements.AdvancementManager;
import net.minestom.server.adventure.bossbar.BossBarManager;
import net.minestom.server.command.CommandManager;
import net.minestom.server.event.GlobalEventHandler;
import net.minestom.server.exception.ExceptionManager;
import net.minestom.server.gamedata.tags.TagManager;
import net.minestom.server.instance.InstanceManager;
import net.minestom.server.instance.block.BlockManager;
import net.minestom.server.listener.manager.PacketListenerManager;
import net.minestom.server.monitoring.BenchmarkManager;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.PacketProcessor;
import net.minestom.server.network.packet.server.play.PluginMessagePacket;
import net.minestom.server.network.packet.server.play.ServerDifficultyPacket;
import net.minestom.server.network.socket.Server;
import net.minestom.server.recipe.RecipeManager;
import net.minestom.server.scoreboard.TeamManager;
import net.minestom.server.thread.TickSchedulerThread;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.PacketUtils;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.Difficulty;
import net.minestom.server.world.DimensionTypeManager;
import net.minestom.server.world.biomes.BiomeManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public final class MinecraftServer {
    public static final ComponentLogger LOGGER = ComponentLogger.logger(MinecraftServer.class);
    public static final String VERSION_NAME = "1.20.1";
    public static final int PROTOCOL_VERSION = 763;
    public static final String THREAD_NAME_BENCHMARK = "Ms-Benchmark";
    public static final String THREAD_NAME_TICK_SCHEDULER = "Ms-TickScheduler";
    public static final String THREAD_NAME_TICK = "Ms-Tick";
    public static final int TICK_PER_SECOND = Integer.getInteger("minestom.tps", 20);
    public static final int TICK_MS = 1000 / TICK_PER_SECOND;
    private static volatile ServerProcess serverProcess;
    private static int chunkViewDistance;
    private static int entityViewDistance;
    private static int compressionThreshold;
    private static boolean terminalEnabled;
    private static String brandName;
    private static Difficulty difficulty;

    public static MinecraftServer init() {
        MinecraftServer.updateProcess();
        return new MinecraftServer();
    }

    @ApiStatus.Internal
    public static ServerProcess updateProcess() {
        ServerProcessImpl process;
        try {
            process = new ServerProcessImpl();
            serverProcess = process;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return process;
    }

    @NotNull
    public static String getBrandName() {
        return brandName;
    }

    public static void setBrandName(@NotNull String brandName) {
        MinecraftServer.brandName = brandName;
        PacketUtils.broadcastPacket(PluginMessagePacket.getBrandPacket());
    }

    @NotNull
    public static Difficulty getDifficulty() {
        return difficulty;
    }

    public static void setDifficulty(@NotNull Difficulty difficulty) {
        MinecraftServer.difficulty = difficulty;
        PacketUtils.broadcastPacket(new ServerDifficultyPacket(difficulty, true));
    }

    @ApiStatus.Experimental
    public static @UnknownNullability ServerProcess process() {
        return serverProcess;
    }

    @NotNull
    public static GlobalEventHandler getGlobalEventHandler() {
        return serverProcess.eventHandler();
    }

    @NotNull
    public static PacketListenerManager getPacketListenerManager() {
        return serverProcess.packetListener();
    }

    @NotNull
    public static InstanceManager getInstanceManager() {
        return serverProcess.instance();
    }

    @NotNull
    public static BlockManager getBlockManager() {
        return serverProcess.block();
    }

    @NotNull
    public static CommandManager getCommandManager() {
        return serverProcess.command();
    }

    @NotNull
    public static RecipeManager getRecipeManager() {
        return serverProcess.recipe();
    }

    @NotNull
    public static TeamManager getTeamManager() {
        return serverProcess.team();
    }

    @NotNull
    public static SchedulerManager getSchedulerManager() {
        return serverProcess.scheduler();
    }

    @NotNull
    public static BenchmarkManager getBenchmarkManager() {
        return serverProcess.benchmark();
    }

    @NotNull
    public static ExceptionManager getExceptionManager() {
        return serverProcess.exception();
    }

    @NotNull
    public static ConnectionManager getConnectionManager() {
        return serverProcess.connection();
    }

    @NotNull
    public static BossBarManager getBossBarManager() {
        return serverProcess.bossBar();
    }

    @NotNull
    public static PacketProcessor getPacketProcessor() {
        return serverProcess.packetProcessor();
    }

    public static boolean isStarted() {
        return serverProcess.isAlive();
    }

    public static boolean isStopping() {
        return !MinecraftServer.isStarted();
    }

    public static int getChunkViewDistance() {
        return chunkViewDistance;
    }

    @Deprecated
    public static void setChunkViewDistance(int chunkViewDistance) {
        Check.stateCondition(serverProcess.isAlive(), "You cannot change the chunk view distance after the server has been started.");
        Check.argCondition(!MathUtils.isBetween(chunkViewDistance, 2, 32), "The chunk view distance must be between 2 and 32");
        MinecraftServer.chunkViewDistance = chunkViewDistance;
    }

    public static int getEntityViewDistance() {
        return entityViewDistance;
    }

    @Deprecated
    public static void setEntityViewDistance(int entityViewDistance) {
        Check.stateCondition(serverProcess.isAlive(), "You cannot change the entity view distance after the server has been started.");
        Check.argCondition(!MathUtils.isBetween(entityViewDistance, 0, 32), "The entity view distance must be between 0 and 32");
        MinecraftServer.entityViewDistance = entityViewDistance;
    }

    public static int getCompressionThreshold() {
        return compressionThreshold;
    }

    public static void setCompressionThreshold(int compressionThreshold) {
        Check.stateCondition(serverProcess.isAlive(), "The compression threshold cannot be changed after the server has been started.");
        MinecraftServer.compressionThreshold = compressionThreshold;
    }

    public static boolean isTerminalEnabled() {
        return terminalEnabled;
    }

    public static void setTerminalEnabled(boolean enabled) {
        Check.stateCondition(serverProcess.isAlive(), "Terminal settings may not be changed after starting the server.");
        terminalEnabled = enabled;
    }

    public static DimensionTypeManager getDimensionTypeManager() {
        return serverProcess.dimension();
    }

    public static BiomeManager getBiomeManager() {
        return serverProcess.biome();
    }

    public static AdvancementManager getAdvancementManager() {
        return serverProcess.advancement();
    }

    public static TagManager getTagManager() {
        return serverProcess.tag();
    }

    public static Server getServer() {
        return serverProcess.server();
    }

    public void start(@NotNull SocketAddress address) {
        serverProcess.start(address);
        new TickSchedulerThread(serverProcess).start();
    }

    public void start(@NotNull String address, int port) {
        this.start(new InetSocketAddress(address, port));
    }

    public static void stopCleanly() {
        serverProcess.stop();
    }

    static {
        chunkViewDistance = Integer.getInteger("minestom.chunk-view-distance", 8);
        entityViewDistance = Integer.getInteger("minestom.entity-view-distance", 5);
        compressionThreshold = 256;
        terminalEnabled = System.getProperty("minestom.terminal.disabled") == null;
        brandName = "Minestom";
        difficulty = Difficulty.NORMAL;
    }
}

