/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.advancements.notifications;

import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minestom.server.advancements.notifications.Notification;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.play.AdvancementsPacket;
import org.jetbrains.annotations.NotNull;

public final class NotificationCenter {
    private static final String IDENTIFIER = "minestom:notification";
    private static final AdvancementsPacket REMOVE_PACKET = new AdvancementsPacket(false, List.of(), List.of("minestom:notification"), List.of());

    private NotificationCenter() {
    }

    public static void send(@NotNull Notification notification, @NotNull Player player) {
        player.sendPacket(NotificationCenter.createPacket(notification));
        player.sendPacket(REMOVE_PACKET);
    }

    public static void send(@NotNull Notification notification, @NotNull Collection<Player> players) {
        players.forEach(player -> NotificationCenter.send(notification, player));
    }

    private static AdvancementsPacket createPacket(Notification notification) {
        AdvancementsPacket.DisplayData displayData = new AdvancementsPacket.DisplayData(notification.title(), (Component)Component.text((String)"Articdive was here. #Minestom"), notification.icon(), notification.frameType(), 6, null, 0.0f, 0.0f);
        AdvancementsPacket.Criteria criteria = new AdvancementsPacket.Criteria("minestom:some_criteria", new AdvancementsPacket.CriterionProgress(System.currentTimeMillis()));
        AdvancementsPacket.Advancement advancement = new AdvancementsPacket.Advancement(null, displayData, List.of(criteria.criterionIdentifier()), List.of(new AdvancementsPacket.Requirement(List.of(criteria.criterionIdentifier()))));
        AdvancementsPacket.AdvancementMapping mapping = new AdvancementsPacket.AdvancementMapping(IDENTIFIER, advancement);
        AdvancementsPacket.ProgressMapping progressMapping = new AdvancementsPacket.ProgressMapping(IDENTIFIER, new AdvancementsPacket.AdvancementProgress(List.of(criteria)));
        return new AdvancementsPacket(false, List.of(mapping), List.of(), List.of(progressMapping));
    }
}

