/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.audience;

import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.audience.AudienceProvider;
import net.minestom.server.adventure.audience.AudienceRegistry;
import net.minestom.server.adventure.audience.IterableAudienceProvider;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.entity.Player;
import org.jetbrains.annotations.NotNull;

class SingleAudienceProvider
implements AudienceProvider<Audience> {
    protected final IterableAudienceProvider collection = new IterableAudienceProvider();
    protected final Audience players = PacketGroupingAudience.of(MinecraftServer.getConnectionManager().getOnlinePlayers());
    protected final Audience server = Audience.audience((Audience[])new Audience[]{this.players, MinecraftServer.getCommandManager().getConsoleSender()});

    protected SingleAudienceProvider() {
    }

    @NotNull
    public IterableAudienceProvider iterable() {
        return this.collection;
    }

    @Override
    @NotNull
    public Audience all() {
        return Audience.audience((Audience[])new Audience[]{this.server, this.customs()});
    }

    @Override
    @NotNull
    public Audience players() {
        return this.players;
    }

    @Override
    @NotNull
    public Audience players(@NotNull Predicate<Player> filter) {
        return PacketGroupingAudience.of(MinecraftServer.getConnectionManager().getOnlinePlayers().stream().filter(filter).toList());
    }

    @Override
    @NotNull
    public Audience console() {
        return MinecraftServer.getCommandManager().getConsoleSender();
    }

    @Override
    @NotNull
    public Audience server() {
        return this.server;
    }

    @Override
    @NotNull
    public Audience customs() {
        return Audience.audience((Iterable)this.iterable().customs());
    }

    @Override
    @NotNull
    public Audience custom(@NotNull Key key) {
        return Audience.audience((Iterable)this.iterable().custom(key));
    }

    @Override
    @NotNull
    public Audience custom(@NotNull Key key, Predicate<Audience> filter) {
        return Audience.audience((Iterable)this.iterable().custom(key, (Predicate)filter));
    }

    @Override
    @NotNull
    public Audience customs(@NotNull Predicate<Audience> filter) {
        return Audience.audience((Iterable)this.iterable().customs((Predicate)filter));
    }

    @Override
    @NotNull
    public Audience all(@NotNull Predicate<Audience> filter) {
        return Audience.audience((Iterable)this.iterable().all((Predicate)filter));
    }

    @Override
    @NotNull
    public AudienceRegistry registry() {
        return this.iterable().registry();
    }
}

