/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.attribute;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Attribute(String key, float defaultValue, float maxValue) {
    private static final Map<String, Attribute> ATTRIBUTES = new ConcurrentHashMap<String, Attribute>();
    public static final Attribute MAX_HEALTH = new Attribute("generic.max_health", 20.0f, 1024.0f).register();
    public static final Attribute FOLLOW_RANGE = new Attribute("generic.follow_range", 32.0f, 2048.0f).register();
    public static final Attribute KNOCKBACK_RESISTANCE = new Attribute("generic.knockback_resistance", 0.0f, 1.0f).register();
    public static final Attribute MOVEMENT_SPEED = new Attribute("generic.movement_speed", 0.25f, 1024.0f).register();
    public static final Attribute ATTACK_DAMAGE = new Attribute("generic.attack_damage", 2.0f, 2048.0f).register();
    public static final Attribute ATTACK_SPEED = new Attribute("generic.attack_speed", 4.0f, 1024.0f).register();
    public static final Attribute FLYING_SPEED = new Attribute("generic.flying_speed", 0.4f, 1024.0f).register();
    public static final Attribute ARMOR = new Attribute("generic.armor", 0.0f, 30.0f).register();
    public static final Attribute ARMOR_TOUGHNESS = new Attribute("generic.armor_toughness", 0.0f, 20.0f).register();
    public static final Attribute ATTACK_KNOCKBACK = new Attribute("generic.attack_knockback", 0.0f, 5.0f).register();
    public static final Attribute LUCK = new Attribute("generic.luck", 0.0f, 1024.0f).register();
    public static final Attribute HORSE_JUMP_STRENGTH = new Attribute("horse.jump_strength", 0.7f, 2.0f).register();
    public static final Attribute ZOMBIE_SPAWN_REINFORCEMENTS = new Attribute("zombie.spawn_reinforcements", 0.0f, 1.0f).register();

    public Attribute {
        if (defaultValue > maxValue) {
            throw new IllegalArgumentException("Default value cannot be greater than the maximum allowed");
        }
    }

    @NotNull
    public Attribute register() {
        ATTRIBUTES.put(this.key, this);
        return this;
    }

    @Nullable
    public static Attribute fromKey(@NotNull String key) {
        return ATTRIBUTES.get(key);
    }

    @NotNull
    public static @NotNull Collection<@NotNull Attribute> values() {
        return ATTRIBUTES.values();
    }
}

