/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.GraphImpl;
import net.minestom.server.command.builder.Command;
import net.minestom.server.command.builder.CommandExecutor;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.condition.CommandCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface Graph {
    @NotNull
    public static Builder builder(@NotNull Argument<?> argument, @Nullable Execution execution) {
        return new GraphImpl.BuilderImpl(argument, execution);
    }

    @NotNull
    public static Builder builder(@NotNull Argument<?> argument) {
        return new GraphImpl.BuilderImpl(argument, null);
    }

    @NotNull
    public static Graph fromCommand(@NotNull Command command) {
        return GraphImpl.fromCommand(command);
    }

    @NotNull
    public static Graph merge(@NotNull @NotNull Collection<@NotNull Command> commands) {
        return GraphImpl.merge(commands);
    }

    @NotNull
    public static Graph merge(@NotNull @NotNull List<@NotNull Graph> graphs) {
        return GraphImpl.merge(graphs);
    }

    @NotNull
    public static Graph merge(Graph ... graphs) {
        return Graph.merge(List.of(graphs));
    }

    @NotNull
    public Node root();

    public boolean compare(@NotNull Graph var1, @NotNull Comparator var2);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Execution
    extends Predicate<CommandSender> {
        public @UnknownNullability CommandExecutor defaultExecutor();

        public @UnknownNullability CommandExecutor globalListener();

        @Nullable
        public CommandExecutor executor();

        @Nullable
        public CommandCondition condition();
    }

    public static enum Comparator {
        TREE;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder {
        @NotNull
        public Builder append(@NotNull Argument<?> var1, @Nullable Execution var2, @NotNull Consumer<Builder> var3);

        @NotNull
        public Builder append(@NotNull Argument<?> var1, @Nullable Execution var2);

        @NotNull
        default public Builder append(@NotNull Argument<?> argument, @NotNull Consumer<Builder> consumer) {
            return this.append(argument, null, consumer);
        }

        @NotNull
        default public Builder append(@NotNull Argument<?> argument) {
            return this.append(argument, (Execution)null);
        }

        @NotNull
        public Graph build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Node {
        @NotNull
        public Argument<?> argument();

        public @UnknownNullability Execution execution();

        @NotNull
        public @NotNull List<@NotNull Node> next();
    }
}

