/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import java.util.function.DoubleUnaryOperator;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Point {
    @Contract(pure=true)
    public double x();

    @Contract(pure=true)
    public double y();

    @Contract(pure=true)
    public double z();

    @Contract(pure=true)
    default public int blockX() {
        return (int)Math.floor(this.x());
    }

    @Contract(pure=true)
    default public int blockY() {
        return (int)Math.floor(this.y());
    }

    @Contract(pure=true)
    default public int blockZ() {
        return (int)Math.floor(this.z());
    }

    @Contract(pure=true)
    default public int chunkX() {
        return ChunkUtils.getChunkCoordinate(this.x());
    }

    @Contract(pure=true)
    @ApiStatus.Experimental
    default public int section() {
        return ChunkUtils.getChunkCoordinate(this.y());
    }

    @Contract(pure=true)
    default public int chunkZ() {
        return ChunkUtils.getChunkCoordinate(this.z());
    }

    @Contract(pure=true)
    @NotNull
    public Point withX(@NotNull DoubleUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public Point withX(double var1);

    @Contract(pure=true)
    @NotNull
    public Point withY(@NotNull DoubleUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public Point withY(double var1);

    @Contract(pure=true)
    @NotNull
    public Point withZ(@NotNull DoubleUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public Point withZ(double var1);

    @Contract(pure=true)
    @NotNull
    public Point add(double var1, double var3, double var5);

    @Contract(pure=true)
    @NotNull
    public Point add(@NotNull Point var1);

    @Contract(pure=true)
    @NotNull
    public Point add(double var1);

    @Contract(pure=true)
    @NotNull
    public Point sub(double var1, double var3, double var5);

    @Contract(pure=true)
    @NotNull
    public Point sub(@NotNull Point var1);

    @Contract(pure=true)
    @NotNull
    public Point sub(double var1);

    @Contract(pure=true)
    @NotNull
    public Point mul(double var1, double var3, double var5);

    @Contract(pure=true)
    @NotNull
    public Point mul(@NotNull Point var1);

    @Contract(pure=true)
    @NotNull
    public Point mul(double var1);

    @Contract(pure=true)
    @NotNull
    public Point div(double var1, double var3, double var5);

    @Contract(pure=true)
    @NotNull
    public Point div(@NotNull Point var1);

    @Contract(pure=true)
    @NotNull
    public Point div(double var1);

    @Contract(pure=true)
    @NotNull
    default public Point relative(@NotNull BlockFace face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case BlockFace.BOTTOM -> this.sub(0.0, 1.0, 0.0);
            case BlockFace.TOP -> this.add(0.0, 1.0, 0.0);
            case BlockFace.NORTH -> this.sub(0.0, 0.0, 1.0);
            case BlockFace.SOUTH -> this.add(0.0, 0.0, 1.0);
            case BlockFace.WEST -> this.sub(1.0, 0.0, 0.0);
            case BlockFace.EAST -> this.add(1.0, 0.0, 0.0);
        };
    }

    @Contract(pure=true)
    default public double distanceSquared(double x, double y, double z) {
        return MathUtils.square(this.x() - x) + MathUtils.square(this.y() - y) + MathUtils.square(this.z() - z);
    }

    @Contract(pure=true)
    default public double distanceSquared(@NotNull Point point) {
        return this.distanceSquared(point.x(), point.y(), point.z());
    }

    @Contract(pure=true)
    default public double distance(double x, double y, double z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    @Contract(pure=true)
    default public double distance(@NotNull Point point) {
        return this.distance(point.x(), point.y(), point.z());
    }

    default public boolean samePoint(double x, double y, double z) {
        return Double.compare(x, this.x()) == 0 && Double.compare(y, this.y()) == 0 && Double.compare(z, this.z()) == 0;
    }

    default public boolean samePoint(@NotNull Point point) {
        return this.samePoint(point.x(), point.y(), point.z());
    }

    default public boolean isZero() {
        return this.x() == 0.0 && this.y() == 0.0 && this.z() == 0.0;
    }

    default public boolean sameChunk(@NotNull Point point) {
        return this.chunkX() == point.chunkX() && this.chunkZ() == point.chunkZ();
    }

    default public boolean sameBlock(int blockX, int blockY, int blockZ) {
        return this.blockX() == blockX && this.blockY() == blockY && this.blockZ() == blockZ;
    }

    default public boolean sameBlock(@NotNull Point point) {
        return this.sameBlock(point.blockX(), point.blockY(), point.blockZ());
    }
}

