/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.ObjectDataProvider;
import net.minestom.server.entity.metadata.other.ExperienceOrbMeta;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.play.SpawnEntityPacket;
import net.minestom.server.network.packet.server.play.SpawnExperienceOrbPacket;
import net.minestom.server.network.packet.server.play.SpawnPlayerPacket;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EntitySpawnType {
    BASE{

        @Override
        public ServerPacket getSpawnPacket(Entity entity) {
            return EntitySpawnType.basicEntity(entity);
        }
    }
    ,
    LIVING{

        @Override
        public ServerPacket getSpawnPacket(Entity entity) {
            return EntitySpawnType.basicEntity(entity);
        }
    }
    ,
    PLAYER{

        @Override
        public ServerPacket getSpawnPacket(Entity entity) {
            return new SpawnPlayerPacket(entity.getEntityId(), entity.getUuid(), entity.getPosition());
        }
    }
    ,
    EXPERIENCE_ORB{

        @Override
        public ServerPacket getSpawnPacket(Entity entity) {
            int n;
            EntityMeta entityMeta = entity.getEntityMeta();
            if (entityMeta instanceof ExperienceOrbMeta) {
                ExperienceOrbMeta experienceOrbMeta = (ExperienceOrbMeta)entityMeta;
                n = experienceOrbMeta.getCount();
            } else {
                n = 0;
            }
            short expCount = (short)n;
            return new SpawnExperienceOrbPacket(entity.getEntityId(), entity.getPosition(), expCount);
        }
    }
    ,
    PAINTING{

        @Override
        public ServerPacket getSpawnPacket(Entity entity) {
            return EntitySpawnType.basicEntity(entity);
        }
    };


    public abstract ServerPacket getSpawnPacket(Entity var1);

    private static SpawnEntityPacket basicEntity(Entity entity) {
        int data = 0;
        short velocityX = 0;
        short velocityZ = 0;
        short velocityY = 0;
        EntityMeta entityMeta = entity.getEntityMeta();
        if (entityMeta instanceof ObjectDataProvider) {
            ObjectDataProvider objectDataProvider = (ObjectDataProvider)((Object)entityMeta);
            data = objectDataProvider.getObjectData();
            if (objectDataProvider.requiresVelocityPacketAtSpawn()) {
                Vec velocity = entity.getVelocityForPacket();
                velocityX = (short)velocity.x();
                velocityY = (short)velocity.y();
                velocityZ = (short)velocity.z();
            }
        }
        Pos position = entity.getPosition();
        return new SpawnEntityPacket(entity.getEntityId(), entity.getUuid(), entity.getEntityType().id(), position, position.yaw(), data, velocityX, velocityY, velocityZ);
    }
}

