/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.sound.Sound;
import net.minestom.server.attribute.Attribute;
import net.minestom.server.attribute.AttributeInstance;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.ItemEntity;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.metadata.LivingEntityMeta;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.entity.EntityDamageEvent;
import net.minestom.server.event.entity.EntityDeathEvent;
import net.minestom.server.event.entity.EntityFireEvent;
import net.minestom.server.event.item.EntityEquipEvent;
import net.minestom.server.event.item.PickupItemEvent;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.inventory.EquipmentHandler;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.server.LazyPacket;
import net.minestom.server.network.packet.server.play.CollectItemPacket;
import net.minestom.server.network.packet.server.play.EntityAnimationPacket;
import net.minestom.server.network.packet.server.play.EntityPropertiesPacket;
import net.minestom.server.network.packet.server.play.SoundEffectPacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.scoreboard.Team;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.block.BlockIterator;
import net.minestom.server.utils.time.Cooldown;
import net.minestom.server.utils.time.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivingEntity
extends Entity
implements EquipmentHandler {
    protected boolean canPickupItem;
    protected Cooldown itemPickupCooldown = new Cooldown(Duration.of(5L, TimeUnit.SERVER_TICK));
    protected boolean isDead;
    protected DamageType lastDamageSource;
    protected BoundingBox expandedBoundingBox;
    private final Map<String, AttributeInstance> attributeModifiers = new ConcurrentHashMap<String, AttributeInstance>();
    protected boolean invulnerable;
    private long fireExtinguishTime;
    private long lastFireDamageTime;
    private long fireDamagePeriod = 1000L;
    private Team team;
    private int arrowCount;
    private float health = 1.0f;
    private ItemStack mainHandItem;
    private ItemStack offHandItem;
    private ItemStack helmet;
    private ItemStack chestplate;
    private ItemStack leggings;
    private ItemStack boots;

    public LivingEntity(@NotNull EntityType entityType, @NotNull UUID uuid) {
        super(entityType, uuid);
        this.initEquipments();
    }

    public LivingEntity(@NotNull EntityType entityType) {
        this(entityType, UUID.randomUUID());
    }

    private void initEquipments() {
        this.mainHandItem = ItemStack.AIR;
        this.offHandItem = ItemStack.AIR;
        this.helmet = ItemStack.AIR;
        this.chestplate = ItemStack.AIR;
        this.leggings = ItemStack.AIR;
        this.boots = ItemStack.AIR;
    }

    @Override
    @NotNull
    public ItemStack getItemInMainHand() {
        return this.mainHandItem;
    }

    @Override
    public void setItemInMainHand(@NotNull ItemStack itemStack) {
        this.mainHandItem = this.getEquipmentItem(itemStack, EquipmentSlot.MAIN_HAND);
        this.syncEquipment(EquipmentSlot.MAIN_HAND);
    }

    @Override
    @NotNull
    public ItemStack getItemInOffHand() {
        return this.offHandItem;
    }

    @Override
    public void setItemInOffHand(@NotNull ItemStack itemStack) {
        this.offHandItem = this.getEquipmentItem(itemStack, EquipmentSlot.OFF_HAND);
        this.syncEquipment(EquipmentSlot.OFF_HAND);
    }

    @Override
    @NotNull
    public ItemStack getHelmet() {
        return this.helmet;
    }

    @Override
    public void setHelmet(@NotNull ItemStack itemStack) {
        this.helmet = this.getEquipmentItem(itemStack, EquipmentSlot.HELMET);
        this.syncEquipment(EquipmentSlot.HELMET);
    }

    @Override
    @NotNull
    public ItemStack getChestplate() {
        return this.chestplate;
    }

    @Override
    public void setChestplate(@NotNull ItemStack itemStack) {
        this.chestplate = this.getEquipmentItem(itemStack, EquipmentSlot.CHESTPLATE);
        this.syncEquipment(EquipmentSlot.CHESTPLATE);
    }

    @Override
    @NotNull
    public ItemStack getLeggings() {
        return this.leggings;
    }

    @Override
    public void setLeggings(@NotNull ItemStack itemStack) {
        this.leggings = this.getEquipmentItem(itemStack, EquipmentSlot.LEGGINGS);
        this.syncEquipment(EquipmentSlot.LEGGINGS);
    }

    @Override
    @NotNull
    public ItemStack getBoots() {
        return this.boots;
    }

    @Override
    public void setBoots(@NotNull ItemStack itemStack) {
        this.boots = this.getEquipmentItem(itemStack, EquipmentSlot.BOOTS);
        this.syncEquipment(EquipmentSlot.BOOTS);
    }

    private ItemStack getEquipmentItem(@NotNull ItemStack itemStack, @NotNull EquipmentSlot slot) {
        EntityEquipEvent entityEquipEvent = new EntityEquipEvent(this, itemStack, slot);
        EventDispatcher.call(entityEquipEvent);
        return entityEquipEvent.getEquippedItem();
    }

    @Override
    public void update(long time) {
        if (this.isOnFire()) {
            if (time > this.fireExtinguishTime) {
                this.setOnFire(false);
            } else if (time - this.lastFireDamageTime > this.fireDamagePeriod) {
                this.damage(DamageType.ON_FIRE, 1.0f);
                this.lastFireDamageTime = time;
            }
        }
        if (this.canPickupItem() && this.itemPickupCooldown.isReady(time)) {
            this.itemPickupCooldown.refreshLastUpdate(time);
            Pos loweredPosition = this.position.sub(0.0, 0.5, 0.0);
            this.instance.getEntityTracker().nearbyEntities(this.position, this.expandedBoundingBox.width(), EntityTracker.Target.ITEMS, itemEntity -> {
                Player player;
                LivingEntity patt6705$temp = this;
                if (patt6705$temp instanceof Player && !itemEntity.isViewer(player = (Player)patt6705$temp)) {
                    return;
                }
                if (!itemEntity.isPickable()) {
                    return;
                }
                if (this.expandedBoundingBox.intersectEntity(loweredPosition, (Entity)itemEntity)) {
                    PickupItemEvent pickupItemEvent = new PickupItemEvent(this, (ItemEntity)itemEntity);
                    EventDispatcher.callCancellable(pickupItemEvent, () -> {
                        ItemStack item = itemEntity.getItemStack();
                        this.sendPacketToViewersAndSelf(new CollectItemPacket(itemEntity.getEntityId(), this.getEntityId(), item.amount()));
                        itemEntity.remove();
                    });
                }
            });
        }
    }

    public int getArrowCount() {
        return this.arrowCount;
    }

    public void setArrowCount(int arrowCount) {
        this.arrowCount = arrowCount;
        LivingEntityMeta meta = this.getLivingEntityMeta();
        if (meta != null) {
            meta.setArrowCount(arrowCount);
        }
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean invulnerable) {
        this.invulnerable = invulnerable;
    }

    public void kill() {
        this.refreshIsDead(true);
        this.triggerStatus((byte)3);
        this.setPose(Entity.Pose.DYING);
        this.setHealth(0.0f);
        this.velocity = Vec.ZERO;
        if (this.hasPassenger()) {
            this.getPassengers().forEach(this::removePassenger);
        }
        EntityDeathEvent entityDeathEvent = new EntityDeathEvent(this);
        EventDispatcher.call(entityDeathEvent);
    }

    public void setFireForDuration(int duration) {
        this.setFireForDuration(duration, TimeUnit.SERVER_TICK);
    }

    public void setFireForDuration(int duration, TemporalUnit temporalUnit) {
        this.setFireForDuration(Duration.of(duration, temporalUnit));
    }

    public void setFireForDuration(Duration duration) {
        EntityFireEvent entityFireEvent = new EntityFireEvent(this, duration);
        if (duration.toMillis() > 0L) {
            EventDispatcher.callCancellable(entityFireEvent, () -> {
                long fireTime = entityFireEvent.getFireTime(TimeUnit.MILLISECOND);
                this.setOnFire(true);
                this.fireExtinguishTime = System.currentTimeMillis() + fireTime;
            });
        } else {
            this.fireExtinguishTime = System.currentTimeMillis();
        }
    }

    public boolean damage(@NotNull DamageType type, float value) {
        if (this.isDead()) {
            return false;
        }
        if (this.isInvulnerable() || this.isImmune(type)) {
            return false;
        }
        EntityDamageEvent entityDamageEvent = new EntityDamageEvent(this, type, value, type.getSound(this));
        EventDispatcher.callCancellable(entityDamageEvent, () -> {
            Player player;
            float additionalHearts;
            LivingEntity patt11706$temp;
            this.lastDamageSource = entityDamageEvent.getDamageType();
            float remainingDamage = entityDamageEvent.getDamage();
            if (entityDamageEvent.shouldAnimate()) {
                this.sendPacketToViewersAndSelf(new EntityAnimationPacket(this.getEntityId(), EntityAnimationPacket.Animation.TAKE_DAMAGE));
            }
            if ((patt11706$temp = this) instanceof Player && (additionalHearts = (player = (Player)patt11706$temp).getAdditionalHearts()) > 0.0f) {
                if (remainingDamage > additionalHearts) {
                    remainingDamage -= additionalHearts;
                    player.setAdditionalHearts(0.0f);
                } else {
                    player.setAdditionalHearts(additionalHearts - remainingDamage);
                    remainingDamage = 0.0f;
                }
            }
            this.setHealth(this.getHealth() - remainingDamage);
            SoundEvent sound = entityDamageEvent.getSound();
            if (sound != null) {
                Sound.Source soundCategory = this instanceof Player ? Sound.Source.PLAYER : Sound.Source.HOSTILE;
                this.sendPacketToViewersAndSelf(new SoundEffectPacket(sound, null, soundCategory, (Point)this.getPosition(), 1.0f, 1.0f, 0L));
            }
        });
        return !entityDamageEvent.isCancelled();
    }

    public boolean isImmune(@NotNull DamageType type) {
        return false;
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        LivingEntityMeta meta;
        this.health = Math.min(health, this.getMaxHealth());
        if (this.health <= 0.0f && !this.isDead) {
            this.kill();
        }
        if ((meta = this.getLivingEntityMeta()) != null) {
            meta.setHealth(this.health);
        }
    }

    @Nullable
    public DamageType getLastDamageSource() {
        return this.lastDamageSource;
    }

    public float getMaxHealth() {
        return this.getAttributeValue(Attribute.MAX_HEALTH);
    }

    public void heal() {
        this.setHealth(this.getAttributeValue(Attribute.MAX_HEALTH));
    }

    @NotNull
    public AttributeInstance getAttribute(@NotNull Attribute attribute) {
        return this.attributeModifiers.computeIfAbsent(attribute.key(), s -> new AttributeInstance(attribute, this::onAttributeChanged));
    }

    protected void onAttributeChanged(@NotNull AttributeInstance attributeInstance) {
        boolean self = false;
        LivingEntity livingEntity = this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PlayerConnection playerConnection = player.playerConnection;
            self = playerConnection != null && playerConnection.getConnectionState() == ConnectionState.PLAY;
        }
        EntityPropertiesPacket propertiesPacket = new EntityPropertiesPacket(this.getEntityId(), List.of(attributeInstance));
        if (self) {
            this.sendPacketToViewersAndSelf(propertiesPacket);
        } else {
            this.sendPacketToViewers(propertiesPacket);
        }
    }

    public float getAttributeValue(@NotNull Attribute attribute) {
        AttributeInstance instance = this.attributeModifiers.get(attribute.key());
        return instance != null ? instance.getValue() : attribute.defaultValue();
    }

    public boolean isDead() {
        return this.isDead;
    }

    public boolean canPickupItem() {
        return this.canPickupItem;
    }

    public void setCanPickupItem(boolean canPickupItem) {
        this.canPickupItem = canPickupItem;
    }

    @Override
    public void updateNewViewer(@NotNull Player player) {
        super.updateNewViewer(player);
        player.sendPacket(new LazyPacket(this::getEquipmentsPacket));
        player.sendPacket(new LazyPacket(this::getPropertiesPacket));
        if (this.getTeam() != null) {
            player.sendPacket(this.getTeam().createTeamsCreationPacket());
        }
    }

    @Override
    public void setBoundingBox(BoundingBox boundingBox) {
        super.setBoundingBox(boundingBox);
        this.expandedBoundingBox = boundingBox.expand(1.0, 0.5, 1.0);
    }

    public void swingMainHand() {
        this.sendPacketToViewers(new EntityAnimationPacket(this.getEntityId(), EntityAnimationPacket.Animation.SWING_MAIN_ARM));
    }

    public void swingOffHand() {
        this.sendPacketToViewers(new EntityAnimationPacket(this.getEntityId(), EntityAnimationPacket.Animation.SWING_OFF_HAND));
    }

    public void refreshActiveHand(boolean isHandActive, boolean offHand, boolean riptideSpinAttack) {
        LivingEntityMeta meta = this.getLivingEntityMeta();
        if (meta != null) {
            meta.setNotifyAboutChanges(false);
            meta.setHandActive(isHandActive);
            meta.setActiveHand(offHand ? Player.Hand.OFF : Player.Hand.MAIN);
            meta.setInRiptideSpinAttack(riptideSpinAttack);
            meta.setNotifyAboutChanges(true);
            this.updatePose();
        }
    }

    public boolean isFlyingWithElytra() {
        return this.entityMeta.isFlyingWithElytra();
    }

    public void setFlyingWithElytra(boolean isFlying) {
        this.entityMeta.setFlyingWithElytra(isFlying);
        this.updatePose();
    }

    protected void refreshIsDead(boolean isDead) {
        this.isDead = isDead;
    }

    @NotNull
    protected EntityPropertiesPacket getPropertiesPacket() {
        return new EntityPropertiesPacket(this.getEntityId(), List.copyOf(this.attributeModifiers.values()));
    }

    @Override
    protected void handleVoid() {
        if (this.getInstance().isInVoid(this.position)) {
            this.damage(DamageType.VOID, 10.0f);
        }
    }

    public long getFireDamagePeriod() {
        return this.fireDamagePeriod;
    }

    public void setFireDamagePeriod(long fireDamagePeriod, @NotNull TemporalUnit temporalUnit) {
        this.setFireDamagePeriod(Duration.of(fireDamagePeriod, temporalUnit));
    }

    public void setFireDamagePeriod(Duration fireDamagePeriod) {
        this.fireDamagePeriod = fireDamagePeriod.toMillis();
    }

    public void setTeam(@Nullable Team team) {
        String member;
        if (this.team == team) {
            return;
        }
        LivingEntity livingEntity = this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            v0 = player.getUsername();
        } else {
            v0 = member = this.uuid.toString();
        }
        if (this.team != null) {
            this.team.removeMember(member);
        }
        this.team = team;
        if (team != null) {
            team.addMember(member);
        }
    }

    @Nullable
    public Team getTeam() {
        return this.team;
    }

    @Nullable
    public Point getTargetBlockPosition(int maxDistance) {
        BlockIterator it = new BlockIterator(this, maxDistance);
        while (it.hasNext()) {
            Point position = (Point)it.next();
            if (this.getInstance().getBlock(position).isAir()) continue;
            return position;
        }
        return null;
    }

    @Nullable
    public LivingEntityMeta getLivingEntityMeta() {
        if (this.entityMeta instanceof LivingEntityMeta) {
            return (LivingEntityMeta)this.entityMeta;
        }
        return null;
    }

    @Override
    public void takeKnockback(float strength, double x, double z) {
        super.takeKnockback(strength *= 1.0f - this.getAttributeValue(Attribute.KNOCKBACK_RESISTANCE), x, z);
    }
}

