/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.fakeplayer;

import com.extollit.gaming.ai.path.HydrazinePathFinder;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.model.IPathingEntity;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.fakeplayer.FakePlayerController;
import net.minestom.server.entity.fakeplayer.FakePlayerOption;
import net.minestom.server.entity.pathfinding.NavigableEntity;
import net.minestom.server.entity.pathfinding.Navigator;
import net.minestom.server.event.EventListener;
import net.minestom.server.event.player.PlayerSpawnEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.player.FakePlayerConnection;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.utils.time.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakePlayer
extends Player
implements NavigableEntity {
    private static final ConnectionManager CONNECTION_MANAGER = MinecraftServer.getConnectionManager();
    private final FakePlayerOption option;
    private final FakePlayerController fakePlayerController;
    private final Navigator navigator = new Navigator(this);
    private EventListener<PlayerSpawnEvent> spawnListener;

    protected FakePlayer(@NotNull UUID uuid, @NotNull String username, @NotNull FakePlayerOption option, @Nullable Consumer<FakePlayer> spawnCallback) {
        super(uuid, username, new FakePlayerConnection());
        this.option = option;
        this.fakePlayerController = new FakePlayerController(this);
        if (spawnCallback != null) {
            this.spawnListener = EventListener.builder(PlayerSpawnEvent.class).handler(event -> {
                if (event.getPlayer().equals(this) && event.isFirstSpawn()) {
                    spawnCallback.accept(this);
                    MinecraftServer.getGlobalEventHandler().removeListener(this.spawnListener);
                }
            }).build();
            MinecraftServer.getGlobalEventHandler().addListener(this.spawnListener);
        }
        CONNECTION_MANAGER.startPlayState(this, option.isRegistered());
    }

    public static void initPlayer(@NotNull UUID uuid, @NotNull String username, @NotNull FakePlayerOption option, @Nullable Consumer<FakePlayer> spawnCallback) {
        new FakePlayer(uuid, username, option, spawnCallback);
    }

    public static void initPlayer(@NotNull UUID uuid, @NotNull String username, @Nullable Consumer<FakePlayer> spawnCallback) {
        FakePlayer.initPlayer(uuid, username, new FakePlayerOption(), spawnCallback);
    }

    @NotNull
    public FakePlayerOption getOption() {
        return this.option;
    }

    @NotNull
    public FakePlayerController getController() {
        return this.fakePlayerController;
    }

    @Override
    public void update(long time) {
        super.update(time);
        this.navigator.tick();
    }

    @Override
    public CompletableFuture<Void> setInstance(@NotNull Instance instance, @NotNull Pos spawnPosition) {
        this.navigator.setPathFinder(new HydrazinePathFinder((IPathingEntity)this.navigator.getPathingEntity(), (IInstanceSpace)instance.getInstanceSpace()));
        return super.setInstance(instance, spawnPosition);
    }

    @Override
    public void updateNewViewer(@NotNull Player player) {
        player.sendPacket(this.getAddPlayerToList());
        this.handleTabList(player.getPlayerConnection());
        super.updateNewViewer(player);
    }

    @Override
    protected void showPlayer(@NotNull PlayerConnection connection) {
        super.showPlayer(connection);
        this.handleTabList(connection);
    }

    @Override
    @NotNull
    public Navigator getNavigator() {
        return this.navigator;
    }

    private void handleTabList(PlayerConnection connection) {
        if (!this.option.isInTabList()) {
            MinecraftServer.getSchedulerManager().buildTask(() -> connection.sendPacket(this.getRemovePlayerToList())).delay(20L, TimeUnit.SERVER_TICK).schedule();
        }
    }
}

