/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.hologram;

import java.util.Set;
import net.kyori.adventure.text.Component;
import net.minestom.server.Viewable;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.metadata.other.ArmorStandMeta;
import net.minestom.server.instance.Instance;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public class Hologram
implements Viewable {
    private static final float OFFSET_Y = -0.9875f;
    private static final float MARKER_OFFSET_Y = -0.40625f;
    private final Entity entity = new Entity(EntityType.ARMOR_STAND);
    private final float yOffset;
    private Pos position;
    private Component text;
    private boolean removed;

    public Hologram(Instance instance, Pos spawnPosition, Component text) {
        this(instance, spawnPosition, text, true);
    }

    public Hologram(Instance instance, Pos spawnPosition, Component text, boolean autoViewable) {
        this(instance, spawnPosition, text, autoViewable, false);
    }

    public Hologram(Instance instance, Pos spawnPosition, Component text, boolean autoViewable, boolean marker) {
        ArmorStandMeta armorStandMeta = (ArmorStandMeta)this.entity.getEntityMeta();
        armorStandMeta.setNotifyAboutChanges(false);
        if (marker) {
            this.yOffset = -0.40625f;
            armorStandMeta.setMarker(true);
        } else {
            this.yOffset = -0.9875f;
            armorStandMeta.setSmall(true);
        }
        armorStandMeta.setHasNoGravity(true);
        armorStandMeta.setCustomName((Component)Component.empty());
        armorStandMeta.setCustomNameVisible(true);
        armorStandMeta.setInvisible(true);
        armorStandMeta.setNotifyAboutChanges(true);
        this.entity.setInstance(instance, spawnPosition.add(0.0, this.yOffset, 0.0));
        this.entity.setAutoViewable(autoViewable);
        this.position = spawnPosition;
        this.setText(text);
    }

    public Pos getPosition() {
        return this.position;
    }

    public void setPosition(Pos position) {
        this.checkRemoved();
        this.position = position.add(0.0, this.yOffset, 0.0);
        this.entity.teleport(this.position);
    }

    public Component getText() {
        return this.text;
    }

    public void setText(Component text) {
        this.checkRemoved();
        this.text = text;
        this.entity.setCustomName(text);
    }

    public void remove() {
        this.removed = true;
        this.entity.remove();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public boolean addViewer(@NotNull Player player) {
        return this.entity.addViewer(player);
    }

    @Override
    public boolean removeViewer(@NotNull Player player) {
        return this.entity.removeViewer(player);
    }

    @Override
    @NotNull
    public Set<Player> getViewers() {
        return this.entity.getViewers();
    }

    private void checkRemoved() {
        Check.stateCondition(this.isRemoved(), "You cannot interact with a removed Hologram");
    }
}

