/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.display;

import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.display.AbstractDisplayMeta;
import org.jetbrains.annotations.NotNull;

public class TextDisplayMeta
extends AbstractDisplayMeta {
    public static final byte OFFSET = 22;
    public static final byte MAX_OFFSET = 27;
    private static final byte SHADOW = 1;
    private static final byte SEE_THROUGH = 2;
    private static final byte USE_DEFAULT_BACKGROUND = 4;
    private static final byte ALIGN_LEFT = 8;
    private static final byte ALIGN_RIGHT = 16;

    public TextDisplayMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    @NotNull
    public Component getText() {
        return (Component)this.metadata.getIndex(22, Component.empty());
    }

    public void setText(@NotNull Component value) {
        this.metadata.setIndex(22, Metadata.Chat(value));
    }

    public int getLineWidth() {
        return this.metadata.getIndex(23, 200);
    }

    public void setLineWidth(int value) {
        this.metadata.setIndex(23, Metadata.VarInt(value));
    }

    public int getBackgroundColor() {
        return this.metadata.getIndex(24, 0x40000000);
    }

    public void setBackgroundColor(int value) {
        this.metadata.setIndex(24, Metadata.VarInt(value));
    }

    public int getTextOpacity() {
        return this.metadata.getIndex(25, -1);
    }

    public void setTextOpacity(byte value) {
        this.metadata.setIndex(25, Metadata.Byte(value));
    }

    public boolean isShadow() {
        return this.getMaskBit(26, (byte)1);
    }

    public void setShadow(boolean value) {
        this.setMaskBit(26, (byte)1, value);
    }

    public boolean isSeeThrough() {
        return this.getMaskBit(26, (byte)2);
    }

    public void setSeeThrough(boolean value) {
        this.setMaskBit(26, (byte)2, value);
    }

    public boolean isUseDefaultBackground() {
        return this.getMaskBit(26, (byte)4);
    }

    public void setUseDefaultBackground(boolean value) {
        this.setMaskBit(26, (byte)4, value);
    }

    public boolean isAlignLeft() {
        return this.getMaskBit(26, (byte)8);
    }

    public void setAlignLeft(boolean value) {
        this.setMaskBit(26, (byte)8, value);
    }

    public boolean isAlignRight() {
        return this.getMaskBit(26, (byte)16);
    }

    public void setAlignRight(boolean value) {
        this.setMaskBit(26, (byte)16, value);
    }
}

