/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.other;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.ObjectDataProvider;
import net.minestom.server.item.ItemStack;
import net.minestom.server.utils.Rotation;
import org.jetbrains.annotations.NotNull;

public class ItemFrameMeta
extends EntityMeta
implements ObjectDataProvider {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 10;
    private Orientation orientation = Orientation.DOWN;

    public ItemFrameMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    @NotNull
    public ItemStack getItem() {
        return this.metadata.getIndex(8, ItemStack.AIR);
    }

    public void setItem(@NotNull ItemStack value) {
        this.metadata.setIndex(8, Metadata.Slot(value));
    }

    @NotNull
    public Rotation getRotation() {
        return Rotation.values()[this.metadata.getIndex(9, 0)];
    }

    public void setRotation(@NotNull Rotation value) {
        this.metadata.setIndex(9, Metadata.VarInt(value.ordinal()));
    }

    @NotNull
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(@NotNull Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public int getObjectData() {
        return this.orientation.ordinal();
    }

    @Override
    public boolean requiresVelocityPacketAtSpawn() {
        return false;
    }

    public static enum Orientation {
        DOWN,
        UP,
        NORTH,
        SOUTH,
        WEST,
        EAST;

    }
}

