/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.water.fish;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.water.fish.AbstractFishMeta;
import org.jetbrains.annotations.NotNull;

public class PufferfishMeta
extends AbstractFishMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 18;

    public PufferfishMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
        this.updateBoundingBox(State.UNPUFFED);
    }

    public State getState() {
        return State.VALUES[this.metadata.getIndex(17, 0)];
    }

    public void setState(State state) {
        this.metadata.setIndex(17, Metadata.VarInt(state.ordinal()));
        this.updateBoundingBox(state);
    }

    private void updateBoundingBox(State state) {
        this.consumeEntity(entity -> {
            switch (state) {
                case UNPUFFED: {
                    entity.setBoundingBox(0.35, 0.35, 0.35);
                    break;
                }
                case SEMI_PUFFED: {
                    entity.setBoundingBox(0.5, 0.5, 0.5);
                    break;
                }
                default: {
                    entity.setBoundingBox(0.7, 0.7, 0.7);
                }
            }
        });
    }

    public static enum State {
        UNPUFFED,
        SEMI_PUFFED,
        FULLY_PUFFED;

        private static final State[] VALUES;

        static {
            VALUES = State.values();
        }
    }
}

