/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.query.response;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.extras.query.Query;
import net.minestom.server.extras.query.response.QueryKey;
import net.minestom.server.utils.binary.BinaryWriter;
import net.minestom.server.utils.binary.Writeable;
import org.jetbrains.annotations.NotNull;

public class FullQueryResponse
implements Writeable {
    private static final PlainComponentSerializer PLAIN = PlainComponentSerializer.plain();
    private static final byte[] PADDING_10 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] PADDING_11 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Map<String, String> kv = new HashMap<String, String>();
    private List<String> players;

    public FullQueryResponse() {
        for (QueryKey key : QueryKey.VALUES) {
            this.kv.put(key.getKey(), key.getValue());
        }
        this.players = MinecraftServer.getConnectionManager().getOnlinePlayers().stream().map(player -> PLAIN.serialize(player.getName())).toList();
    }

    public void put(@NotNull QueryKey key, @NotNull String value) {
        this.put(key.getKey(), value);
    }

    public void put(@NotNull String key, @NotNull String value) {
        this.kv.put(key, value);
    }

    @NotNull
    public Map<String, String> getKeyValuesMap() {
        return this.kv;
    }

    public void setKeyValuesMap(@NotNull Map<String, String> map) {
        this.kv = Objects.requireNonNull(map, "map");
    }

    public void addPlayers(String ... players) {
        Collections.addAll(this.players, players);
    }

    public void addPlayers(@NotNull Collection<String> players) {
        this.players.addAll(players);
    }

    @NotNull
    public List<String> getPlayers() {
        return this.players;
    }

    public void setPlayers(@NotNull List<String> players) {
        this.players = Objects.requireNonNull(players, "players");
    }

    public static String generatePluginsValue() {
        StringBuilder builder = new StringBuilder(MinecraftServer.getBrandName()).append(' ').append("1.20.1");
        return builder.toString();
    }

    @Override
    public void write(@NotNull BinaryWriter writer) {
        writer.writeBytes(PADDING_11);
        for (Map.Entry<String, String> entry : this.kv.entrySet()) {
            writer.writeNullTerminatedString(entry.getKey(), Query.CHARSET);
            writer.writeNullTerminatedString(entry.getValue(), Query.CHARSET);
        }
        writer.writeNullTerminatedString("", Query.CHARSET);
        writer.writeBytes(PADDING_10);
        for (String player : this.players) {
            writer.writeNullTerminatedString(player, Query.CHARSET);
        }
        writer.writeNullTerminatedString("", Query.CHARSET);
    }
}

