/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ranges.IntRange;
import net.minestom.server.MinecraftServer;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.IChunkLoader;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.world.biomes.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.mca.AnvilException;
import org.jglrxavpok.hephaistos.mca.BiomePalette;
import org.jglrxavpok.hephaistos.mca.BlockPalette;
import org.jglrxavpok.hephaistos.mca.BlockState;
import org.jglrxavpok.hephaistos.mca.ChunkColumn;
import org.jglrxavpok.hephaistos.mca.ChunkSection;
import org.jglrxavpok.hephaistos.mca.CoordinatesKt;
import org.jglrxavpok.hephaistos.mca.RegionFile;
import org.jglrxavpok.hephaistos.mca.SupportedVersion;
import org.jglrxavpok.hephaistos.mca.readers.ChunkReader;
import org.jglrxavpok.hephaistos.mca.readers.ChunkSectionReader;
import org.jglrxavpok.hephaistos.mca.readers.SectionBiomeInformation;
import org.jglrxavpok.hephaistos.mca.writer.ChunkSectionWriter;
import org.jglrxavpok.hephaistos.mca.writer.ChunkWriter;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTCompoundLike;
import org.jglrxavpok.hephaistos.nbt.NBTException;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTReader;
import org.jglrxavpok.hephaistos.nbt.NBTString;
import org.jglrxavpok.hephaistos.nbt.NBTType;
import org.jglrxavpok.hephaistos.nbt.NBTWriter;
import org.jglrxavpok.hephaistos.nbt.mutable.MutableNBTCompound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnvilLoader
implements IChunkLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnvilLoader.class);
    private static final Biome BIOME = Biome.PLAINS;
    private final Map<String, RegionFile> alreadyLoaded = new ConcurrentHashMap<String, RegionFile>();
    private final Path path;
    private final Path levelPath;
    private final Path regionPath;
    private final RegionCache perRegionLoadedChunks = new RegionCache();
    private final ThreadLocal<Int2ObjectMap<BlockState>> blockStateId2ObjectCacheTLS = ThreadLocal.withInitial(Int2ObjectArrayMap::new);

    public AnvilLoader(@NotNull Path path) {
        this.path = path;
        this.levelPath = path.resolve("level.dat");
        this.regionPath = path.resolve("region");
    }

    public AnvilLoader(@NotNull String path) {
        this(Path.of(path, new String[0]));
    }

    @Override
    public void loadInstance(@NotNull Instance instance) {
        if (!Files.exists(this.levelPath, new LinkOption[0])) {
            return;
        }
        try (NBTReader reader = new NBTReader(Files.newInputStream(this.levelPath, new OpenOption[0]));){
            NBTCompound tag = (NBTCompound)reader.read();
            Files.copy(this.levelPath, this.path.resolve("level.dat_old"), StandardCopyOption.REPLACE_EXISTING);
            instance.tagHandler().updateContent((NBTCompoundLike)tag);
        }
        catch (IOException | NBTException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
    }

    @Override
    public @NotNull CompletableFuture<@Nullable Chunk> loadChunk(@NotNull Instance instance, int chunkX, int chunkZ) {
        LOGGER.debug("Attempt loading at {} {}", (Object)chunkX, (Object)chunkZ);
        if (!Files.exists(this.path, new LinkOption[0])) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            return this.loadMCA(instance, chunkX, chunkZ);
        }
        catch (Exception e) {
            MinecraftServer.getExceptionManager().handleException(e);
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @NotNull CompletableFuture<@Nullable Chunk> loadMCA(Instance instance, int chunkX, int chunkZ) throws IOException, AnvilException {
        RegionFile mcaFile = this.getMCAFile(instance, chunkX, chunkZ);
        if (mcaFile == null) {
            return CompletableFuture.completedFuture(null);
        }
        NBTCompound chunkData = mcaFile.getChunkData(chunkX, chunkZ);
        if (chunkData == null) {
            return CompletableFuture.completedFuture(null);
        }
        ChunkReader chunkReader = new ChunkReader(chunkData);
        Chunk chunk = instance.getChunkSupplier().createChunk(instance, chunkX, chunkZ);
        Object object = chunk;
        synchronized (object) {
            IntRange yRange = chunkReader.getYRange();
            if (yRange.getStart() < instance.getDimensionType().getMinY()) {
                throw new AnvilException(String.format("Trying to load chunk with minY = %d, but instance dimension type (%s) has a minY of %d", yRange.getStart(), instance.getDimensionType().getName().asString(), instance.getDimensionType().getMinY()));
            }
            if (yRange.getEndInclusive() > instance.getDimensionType().getMaxY()) {
                throw new AnvilException(String.format("Trying to load chunk with maxY = %d, but instance dimension type (%s) has a maxY of %d", yRange.getEndInclusive(), instance.getDimensionType().getName().asString(), instance.getDimensionType().getMaxY()));
            }
            this.loadSections(chunk, chunkReader);
            this.loadBlockEntities(chunk, chunkReader);
        }
        object = this.perRegionLoadedChunks;
        synchronized (object) {
            int regionX = CoordinatesKt.chunkToRegion((int)chunkX);
            int regionZ = CoordinatesKt.chunkToRegion((int)chunkZ);
            Set chunks = this.perRegionLoadedChunks.computeIfAbsent(new IntIntImmutablePair(regionX, regionZ), r -> new HashSet());
            chunks.add(new IntIntImmutablePair(chunkX, chunkZ));
        }
        return CompletableFuture.completedFuture(chunk);
    }

    @Nullable
    private RegionFile getMCAFile(Instance instance, int chunkX, int chunkZ) {
        int regionX = CoordinatesKt.chunkToRegion((int)chunkX);
        int regionZ = CoordinatesKt.chunkToRegion((int)chunkZ);
        return this.alreadyLoaded.computeIfAbsent(RegionFile.Companion.createFileName(regionX, regionZ), n -> {
            try {
                Path regionPath = this.regionPath.resolve((String)n);
                if (!Files.exists(regionPath, new LinkOption[0])) {
                    return null;
                }
                RegionCache regionCache = this.perRegionLoadedChunks;
                synchronized (regionCache) {
                    Set previousVersion = this.perRegionLoadedChunks.put(new IntIntImmutablePair(regionX, regionZ), new HashSet());
                    assert (previousVersion == null) : "The AnvilLoader cache should not already have data for this region.";
                }
                return new RegionFile(new RandomAccessFile(regionPath.toFile(), "rw"), regionX, regionZ, instance.getDimensionType().getMinY(), instance.getDimensionType().getMaxY() - 1);
            }
            catch (IOException | AnvilException e) {
                MinecraftServer.getExceptionManager().handleException(e);
                return null;
            }
        });
    }

    private void loadSections(Chunk chunk, ChunkReader chunkReader) {
        HashMap<String, Biome> biomeCache = new HashMap<String, Biome>();
        for (NBTCompound sectionNBT : chunkReader.getSections()) {
            NBTList blockPalette;
            SectionBiomeInformation sectionBiomeInformation;
            ChunkSectionReader sectionReader = new ChunkSectionReader(chunkReader.getMinecraftVersion(), sectionNBT);
            if (sectionReader.isSectionEmpty()) continue;
            byte sectionY = sectionReader.getY();
            int yOffset = 16 * sectionY;
            Section section = chunk.getSection(sectionY);
            if (sectionReader.getSkyLight() != null) {
                section.setSkyLight(sectionReader.getSkyLight().copyArray());
            }
            if (sectionReader.getBlockLight() != null) {
                section.setBlockLight(sectionReader.getBlockLight().copyArray());
            }
            if (chunkReader.getGenerationStatus().compareTo((Enum)ChunkColumn.GenerationStatus.Biomes) > 0 && (sectionBiomeInformation = chunkReader.readSectionBiomes(sectionReader)) != null && sectionBiomeInformation.hasBiomeInformation()) {
                if (sectionBiomeInformation.isFilledWithSingleBiome()) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            for (x = 0; x < 16; ++x) {
                                int finalX = chunk.chunkX * 16 + x;
                                int finalZ = chunk.chunkZ * 16 + z;
                                int finalY = sectionY * 16 + y;
                                String biomeName = sectionBiomeInformation.getBaseBiome();
                                Biome biome = biomeCache.computeIfAbsent(biomeName, n -> Objects.requireNonNullElse(MinecraftServer.getBiomeManager().getByName(NamespaceID.from(n)), BIOME));
                                chunk.setBiome(finalX, finalY, finalZ, biome);
                            }
                        }
                    }
                } else {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            for (x = 0; x < 16; ++x) {
                                int finalX = chunk.chunkX * 16 + x;
                                int finalZ = chunk.chunkZ * 16 + z;
                                int finalY = sectionY * 16 + y;
                                int index = x / 4 + z / 4 * 4 + y / 4 * 16;
                                String biomeName = sectionBiomeInformation.getBiomes()[index];
                                Biome biome = biomeCache.computeIfAbsent(biomeName, n -> Objects.requireNonNullElse(MinecraftServer.getBiomeManager().getByName(NamespaceID.from(n)), BIOME));
                                chunk.setBiome(finalX, finalY, finalZ, biome);
                            }
                        }
                    }
                }
            }
            if ((blockPalette = sectionReader.getBlockPalette()) == null) continue;
            int[] blockStateIndices = sectionReader.getUncompressedBlockStateIDs();
            Block[] convertedPalette = new Block[blockPalette.getSize()];
            for (int i = 0; i < convertedPalette.length; ++i) {
                BlockHandler handler;
                NBTCompound paletteEntry = (NBTCompound)blockPalette.get(i);
                String blockName = Objects.requireNonNull(paletteEntry.getString("Name"));
                if (blockName.equals("minecraft:air")) {
                    convertedPalette[i] = Block.AIR;
                    continue;
                }
                Block block = Objects.requireNonNull(Block.fromNamespaceId(blockName));
                HashMap<String, String> properties = new HashMap<String, String>();
                NBTCompound propertiesNBT = paletteEntry.getCompound("Properties");
                if (propertiesNBT != null) {
                    for (Map.Entry property : propertiesNBT) {
                        if (((NBT)property.getValue()).getID() != NBTType.TAG_String) {
                            LOGGER.warn("Fail to parse block state properties {}, expected a TAG_String for {}, but contents were {}", new Object[]{propertiesNBT, property.getKey(), ((NBT)property.getValue()).toSNBT()});
                            continue;
                        }
                        properties.put((String)property.getKey(), ((NBTString)property.getValue()).getValue());
                    }
                }
                if (!properties.isEmpty()) {
                    block = block.withProperties(properties);
                }
                if ((handler = MinecraftServer.getBlockManager().getHandler(block.name())) != null) {
                    block = block.withHandler(handler);
                }
                convertedPalette[i] = block;
            }
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        try {
                            int blockIndex = y * 16 * 16 + z * 16 + x;
                            int paletteIndex = blockStateIndices[blockIndex];
                            Block block = convertedPalette[paletteIndex];
                            chunk.setBlock(x, y + yOffset, z, block);
                            continue;
                        }
                        catch (Exception e) {
                            MinecraftServer.getExceptionManager().handleException(e);
                        }
                    }
                }
            }
        }
    }

    private void loadBlockEntities(Chunk loadedChunk, ChunkReader chunkReader) {
        for (NBTCompound te : chunkReader.getBlockEntities()) {
            Integer x = te.getInt("x");
            Integer y = te.getInt("y");
            Integer z = te.getInt("z");
            if (x == null || y == null || z == null) {
                LOGGER.warn("Tile entity has failed to load due to invalid coordinate");
                continue;
            }
            Block block = loadedChunk.getBlock(x, y, z);
            String tileEntityID = te.getString("id");
            if (tileEntityID != null) {
                BlockHandler handler = MinecraftServer.getBlockManager().getHandlerOrDummy(tileEntityID);
                block = block.withHandler(handler);
            }
            MutableNBTCompound mutableCopy = te.toMutableCompound();
            mutableCopy.remove("id");
            mutableCopy.remove("x");
            mutableCopy.remove("y");
            mutableCopy.remove("z");
            mutableCopy.remove("keepPacked");
            Block finalBlock = mutableCopy.getSize() > 0 ? block.withNbt(mutableCopy.toCompound()) : block;
            loadedChunk.setBlock(x, y, z, finalBlock);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Void> saveInstance(@NotNull Instance instance) {
        NBTCompound nbt = instance.tagHandler().asCompound();
        if (nbt.isEmpty()) {
            return AsyncUtils.VOID_FUTURE;
        }
        try (NBTWriter writer = new NBTWriter(Files.newOutputStream(this.levelPath, new OpenOption[0]));){
            writer.writeNamed("", (NBT)nbt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return AsyncUtils.VOID_FUTURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Void> saveChunk(@NotNull Chunk chunk) {
        RegionFile mcaFile;
        int chunkX = chunk.getChunkX();
        int chunkZ = chunk.getChunkZ();
        Map<String, RegionFile> map = this.alreadyLoaded;
        synchronized (map) {
            mcaFile = this.getMCAFile(chunk.instance, chunkX, chunkZ);
            if (mcaFile == null) {
                int regionX = CoordinatesKt.chunkToRegion((int)chunkX);
                int regionZ = CoordinatesKt.chunkToRegion((int)chunkZ);
                String n = RegionFile.Companion.createFileName(regionX, regionZ);
                File regionFile = new File(this.regionPath.toFile(), n);
                try {
                    if (!regionFile.exists()) {
                        if (!regionFile.getParentFile().exists()) {
                            regionFile.getParentFile().mkdirs();
                        }
                        regionFile.createNewFile();
                    }
                    mcaFile = new RegionFile(new RandomAccessFile(regionFile, "rw"), regionX, regionZ);
                    this.alreadyLoaded.put(n, mcaFile);
                }
                catch (IOException | AnvilException e) {
                    LOGGER.error("Failed to save chunk " + chunkX + ", " + chunkZ, e);
                    MinecraftServer.getExceptionManager().handleException(e);
                    return AsyncUtils.VOID_FUTURE;
                }
            }
        }
        ChunkWriter writer = new ChunkWriter(SupportedVersion.Companion.getLatest());
        this.save(chunk, writer);
        try {
            LOGGER.debug("Attempt saving at {} {}", (Object)chunk.getChunkX(), (Object)chunk.getChunkZ());
            mcaFile.writeColumnData(writer.toNBT(), chunk.getChunkX(), chunk.getChunkZ());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save chunk " + chunkX + ", " + chunkZ, (Throwable)e);
            MinecraftServer.getExceptionManager().handleException(e);
            return AsyncUtils.VOID_FUTURE;
        }
        return AsyncUtils.VOID_FUTURE;
    }

    private BlockState getBlockState(Block block) {
        return (BlockState)this.blockStateId2ObjectCacheTLS.get().computeIfAbsent((int)block.stateId(), _unused -> new BlockState(block.name(), block.properties()));
    }

    private void save(Chunk chunk, ChunkWriter chunkWriter) {
        int minY = chunk.getMinSection() * 16;
        int maxY = chunk.getMaxSection() * 16 - 1;
        chunkWriter.setYPos(minY);
        ArrayList<NBTCompound> blockEntities = new ArrayList<NBTCompound>();
        chunkWriter.setStatus(ChunkColumn.GenerationStatus.Full);
        ArrayList<NBTCompound> sectionData = new ArrayList<NBTCompound>((maxY - minY + 1) / 16);
        int[] palettedBiomes = new int[ChunkSection.Companion.getBiomeArraySize()];
        int[] palettedBlockStates = new int[4096];
        for (int sectionY = chunk.getMinSection(); sectionY < chunk.getMaxSection(); ++sectionY) {
            ChunkSectionWriter sectionWriter = new ChunkSectionWriter(SupportedVersion.Companion.getLatest(), (byte)sectionY);
            Section section = chunk.getSection(sectionY);
            sectionWriter.setSkyLights(section.skyLight().array());
            sectionWriter.setBlockLights(section.blockLight().array());
            BiomePalette biomePalette = new BiomePalette();
            BlockPalette blockPalette = new BlockPalette();
            for (int sectionLocalY = 0; sectionLocalY < 16; ++sectionLocalY) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        MutableNBTCompound nbt;
                        int y = sectionLocalY + sectionY * 16;
                        int blockIndex = x + sectionLocalY * 16 * 16 + z * 16;
                        Block block = chunk.getBlock(x, y, z);
                        BlockState hephaistosBlockState = this.getBlockState(block);
                        blockPalette.increaseReference((Object)hephaistosBlockState);
                        palettedBlockStates[blockIndex] = blockPalette.getPaletteIndex((Object)hephaistosBlockState);
                        if (x % 4 == 0 && sectionLocalY % 4 == 0 && z % 4 == 0) {
                            int biomeIndex = x / 4 + sectionLocalY / 4 * 4 * 4 + z / 4 * 4;
                            Biome biome = chunk.getBiome(x, y, z);
                            String biomeName = biome.name().asString();
                            biomePalette.increaseReference((Object)biomeName);
                            palettedBiomes[biomeIndex] = biomePalette.getPaletteIndex((Object)biomeName);
                        }
                        BlockHandler handler = block.handler();
                        NBTCompound originalNBT = block.nbt();
                        if (originalNBT == null && handler == null) continue;
                        MutableNBTCompound mutableNBTCompound = nbt = originalNBT != null ? originalNBT.toMutableCompound() : new MutableNBTCompound();
                        if (handler != null) {
                            nbt.setString("id", handler.getNamespaceId().asString());
                        }
                        nbt.setInt("x", x + 16 * chunk.getChunkX());
                        nbt.setInt("y", y);
                        nbt.setInt("z", z + 16 * chunk.getChunkZ());
                        nbt.setByte("keepPacked", (byte)0);
                        blockEntities.add(nbt.toCompound());
                    }
                }
            }
            sectionWriter.setPalettedBiomes(biomePalette, palettedBiomes);
            sectionWriter.setPalettedBlockStates(blockPalette, palettedBlockStates);
            sectionData.add(sectionWriter.toNBT());
        }
        chunkWriter.setSectionsData(NBT.List((NBTType)NBTType.TAG_Compound, sectionData));
        chunkWriter.setBlockEntityData(NBT.List((NBTType)NBTType.TAG_Compound, blockEntities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadChunk(Chunk chunk) {
        int regionX = CoordinatesKt.chunkToRegion((int)chunk.chunkX);
        int regionZ = CoordinatesKt.chunkToRegion((int)chunk.chunkZ);
        IntIntImmutablePair regionKey = new IntIntImmutablePair(regionX, regionZ);
        RegionCache regionCache = this.perRegionLoadedChunks;
        synchronized (regionCache) {
            Set chunks = (Set)this.perRegionLoadedChunks.get(regionKey);
            if (chunks != null) {
                chunks.remove(new IntIntImmutablePair(chunk.chunkX, chunk.chunkZ));
                if (chunks.isEmpty()) {
                    this.perRegionLoadedChunks.remove(regionKey);
                    RegionFile regionFile = this.alreadyLoaded.remove(RegionFile.Companion.createFileName(regionX, regionZ));
                    if (regionFile != null) {
                        try {
                            regionFile.close();
                        }
                        catch (IOException e) {
                            MinecraftServer.getExceptionManager().handleException(e);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean supportsParallelLoading() {
        return true;
    }

    @Override
    public boolean supportsParallelSaving() {
        return true;
    }

    private static class RegionCache
    extends ConcurrentHashMap<IntIntImmutablePair, Set<IntIntImmutablePair>> {
        private RegionCache() {
        }
    }
}

